/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.ast.CharClasses;
import dev.yasint.regexsynth.ast.Quantifiers;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.RegexSynth;
import org.junit.Assert;
import org.junit.Test;

public final class QuantifiersTest {
    @Test
    public void itShouldAppendOneOrMoreTimesQuantifierToExpression() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.oneOrMoreTimes((Expression)CharClasses.Posix.digit())}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[0-9]+");
    }

    @Test
    public void itShouldAppendZeroOrMoreTimesQuantifierToExpression() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.zeroOrMoreTimes((Expression)CharClasses.Posix.digit())}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[0-9]*");
    }

    @Test
    public void itShouldAppendExactlyOrMoreTimesQuantifierToExpression() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.exactlyOrMoreTimes((int)2, (Expression)CharClasses.Posix.digit())}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[0-9]{2,}");
        expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.exactlyOrMoreTimes((int)0, (Expression)CharClasses.Posix.digit())}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[0-9]*");
        expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.exactlyOrMoreTimes((int)1, (Expression)CharClasses.Posix.digit())}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[0-9]+");
    }

    @Test
    public void itShouldAppendOptionalQuantifierToExpression() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.optional((Expression)CharClasses.Posix.digit())}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[0-9]?");
    }

    @Test
    public void itShouldAppendExactlyNQuantifierToExpression() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.exactly((int)5, (Expression)CharClasses.Posix.digit())}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[0-9]{5}");
    }

    @Test
    public void itShouldAppendBetweenQuantifierToExpression() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.between((int)5, (int)10, (Expression)CharClasses.Posix.digit())}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[0-9]{5,10}");
    }

    @Test
    public void itShouldAppendLazyQuantifierToExpression() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.lazy((Expression)Quantifiers.between((int)5, (int)10, (Expression)CharClasses.Posix.digit()))}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[0-9]{5,10}?");
    }

    @Test(expected=RuntimeException.class)
    public void itShouldThrowAnExceptionWhenExactlyQuantifierIsRedundant() {
        RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.exactly((int)1, (Expression)CharClasses.Posix.digit())}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
    }

    @Test(expected=RuntimeException.class)
    public void itShouldThrowAnExceptionWhenExactlyQuantifierAppliedExpressionIsRedundant() {
        RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.exactly((int)0, (Expression)CharClasses.Posix.digit())}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
    }
}

