/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.ast.CharClasses;
import dev.yasint.regexsynth.ast.Quantifiers;
import dev.yasint.regexsynth.ast.RegexSet;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.RegexSynth;
import org.junit.Assert;
import org.junit.Test;

public final class CharClassesTest {
    @Test
    public void itShouldAppendMatchAnyCharacterAtPosition() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Quantifiers.exactly((int)5, (Expression)CharClasses.anything())}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)".{5}");
    }

    @Test
    public void itShouldCreateCorrectPOSIXLowerCaseCharClass() {
        RegexSet set = CharClasses.Posix.lowercaseChar();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[a-z]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXUpperCaseCharClass() {
        RegexSet set = CharClasses.Posix.uppercaseChar();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[A-Z]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXAlphabeticCharClass() {
        RegexSet set = CharClasses.Posix.alphabeticChar();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[A-Za-z]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXDigitCharClass() {
        RegexSet set = CharClasses.Posix.digit();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[0-9]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXNotDigitCharClass() {
        RegexSet set = CharClasses.Posix.notDigit();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[^0-9]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXAlphanumericCharClass() {
        RegexSet set = CharClasses.Posix.alphanumericChar();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[0-9A-Za-z]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXPunctCharClass() {
        RegexSet set = CharClasses.Posix.punctuationChar();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[!-\\/:-@[-`{-~]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXGraphCharClass() {
        RegexSet set = CharClasses.Posix.graphicalChar();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[!-~]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXPrintableCharClass() {
        RegexSet set = CharClasses.Posix.printableChar();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[ -~]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXBlankCharClass() {
        RegexSet set = CharClasses.Posix.blankChar();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[\\x09 ]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXHexDigitCharClass() {
        RegexSet set = CharClasses.Posix.hexDigit();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[0-9A-Fa-f]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXWhitespaceCharClass() {
        RegexSet set = CharClasses.Posix.whitespaceChar();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[\\x09-\\x0D ]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXNonWhitespaceCharClass() {
        RegexSet set = CharClasses.Posix.notWhitespace();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[^\\x09-\\x0D ]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXWordCharClass() {
        RegexSet set = CharClasses.Posix.word();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[0-9A-Z_a-z]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXWorNotWordCharClass() {
        RegexSet set = CharClasses.Posix.notWord();
        Assert.assertEquals((Object)set.toRegex().toString(), (Object)"[^0-9A-Z_a-z]");
    }

    @Test
    public void itShouldReturnCorrectEscapeSequence() {
        RegexSet backslash = CharClasses.EscapeSequences.backslash();
        RegexSet bell = CharClasses.EscapeSequences.bell();
        RegexSet horizontalTab = CharClasses.EscapeSequences.horizontalTab();
        RegexSet linebreak = CharClasses.EscapeSequences.linebreak();
        RegexSet verticalTab = CharClasses.EscapeSequences.verticalTab();
        RegexSet formfeed = CharClasses.EscapeSequences.formfeed();
        RegexSet carriageReturn = CharClasses.EscapeSequences.carriageReturn();
        Assert.assertEquals((Object)backslash.toRegex().toString(), (Object)"\\\\");
        Assert.assertEquals((Object)bell.toRegex().toString(), (Object)"\\x07");
        Assert.assertEquals((Object)horizontalTab.toRegex().toString(), (Object)"\\x09");
        Assert.assertEquals((Object)linebreak.toRegex().toString(), (Object)"\\x0A");
        Assert.assertEquals((Object)verticalTab.toRegex().toString(), (Object)"\\x0B");
        Assert.assertEquals((Object)formfeed.toRegex().toString(), (Object)"\\x0C");
        Assert.assertEquals((Object)carriageReturn.toRegex().toString(), (Object)"\\x0D");
    }

    @Test
    public void itShouldCreateAllAsciiCharClassRange() {
        RegexSet ascii = CharClasses.Posix.asciiChar();
        Assert.assertEquals((Object)ascii.toRegex().toString(), (Object)"[\\x00-\\x7F]");
    }

    @Test
    public void itShouldCreateAllExtendedAsciiCharClassRange() {
        RegexSet ascii = CharClasses.Posix.ascii2Char();
        Assert.assertEquals((Object)ascii.toRegex().toString(), (Object)"[\\x00-\u00ff]");
    }

    @Test
    public void itShouldCreateARangedCharClassWhenGivenTwoCodepoints() {
        String from = "\ud83c\udf11";
        String to = "\ud83c\udf1d";
        RegexSet regexSet = CharClasses.rangedSet((String)"\ud83c\udf11", (String)"\ud83c\udf1d");
        Assert.assertEquals((Object)regexSet.toRegex().toString(), (Object)"[\\x{1f311}-\\x{1f31d}]");
    }
}

