/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.materials;

import dev.whyoleg.cryptography.materials.key.Key;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B%\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/materials/JdkSecretKeyDecoder;", "KF", "Ldev/whyoleg/cryptography/materials/key/KeyFormat;", "K", "Ldev/whyoleg/cryptography/materials/key/Key;", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "algorithm", "", "keyWrapper", "Lkotlin/Function1;", "Ljavax/crypto/SecretKey;", "Ldev/whyoleg/cryptography/providers/jdk/JSecretKey;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "decodeFromBlocking", "format", "input", "", "(Ldev/whyoleg/cryptography/materials/key/KeyFormat;[B)Ldev/whyoleg/cryptography/materials/key/Key;", "cryptography-provider-jdk"})
public final class JdkSecretKeyDecoder<KF extends KeyFormat, K extends Key>
implements KeyDecoder<KF, K> {
    @NotNull
    private final String algorithm;
    @NotNull
    private final Function1<SecretKey, K> keyWrapper;

    public JdkSecretKeyDecoder(@NotNull String algorithm, @NotNull Function1<? super SecretKey, ? extends K> keyWrapper2) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(keyWrapper2, (String)"keyWrapper");
        this.algorithm = algorithm;
        this.keyWrapper = keyWrapper2;
    }

    @NotNull
    public K decodeFromBlocking(@NotNull KF format, @NotNull byte[] input) {
        Intrinsics.checkNotNullParameter(format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!Intrinsics.areEqual((Object)format.getName(), (Object)"RAW")) {
            throw new IllegalStateException((format + " is not supported").toString());
        }
        return (K)((Key)this.keyWrapper.invoke((Object)new SecretKeySpec(input, this.algorithm)));
    }
}

