/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.materials;

import dev.whyoleg.cryptography.materials.key.EncodableKey;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import java.security.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0004J\b\u0010\f\u001a\u00020\u000bH\u0004R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey;", "KF", "Ldev/whyoleg/cryptography/materials/key/KeyFormat;", "Ldev/whyoleg/cryptography/materials/key/EncodableKey;", "key", "Ljava/security/Key;", "Ldev/whyoleg/cryptography/providers/jdk/JKey;", "pemAlgorithm", "", "(Ljava/security/Key;Ljava/lang/String;)V", "encodeToDer", "", "encodeToRaw", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkEncodableKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEncodableKey.kt\ndev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public abstract class JdkEncodableKey<KF extends KeyFormat>
implements EncodableKey<KF> {
    @NotNull
    private final Key key;
    @NotNull
    private final String pemAlgorithm;

    public JdkEncodableKey(@NotNull Key key, @NotNull String pemAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)pemAlgorithm, (String)"pemAlgorithm");
        this.key = key;
        this.pemAlgorithm = pemAlgorithm;
    }

    public /* synthetic */ JdkEncodableKey(Key key, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string2 = key.getAlgorithm();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAlgorithm(...)");
            string = string2;
        }
        this(key, string);
    }

    @NotNull
    protected final byte[] encodeToRaw() {
        if (!Intrinsics.areEqual((Object)this.key.getFormat(), (Object)"RAW")) {
            boolean bl = false;
            String string = "Wrong JDK Key format, expected `RAW` got `" + this.key.getFormat() + '`';
            throw new IllegalStateException(string.toString());
        }
        byte[] byArray = this.key.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    @NotNull
    protected final byte[] encodeToDer() {
        if (!(Intrinsics.areEqual((Object)this.key.getFormat(), (Object)"PKCS#8") || Intrinsics.areEqual((Object)this.key.getFormat(), (Object)"X.509"))) {
            boolean bl = false;
            String string = "Wrong JDK Key format, expected `PKCS#8` or `X.509 got `" + this.key.getFormat() + '`';
            throw new IllegalStateException(string.toString());
        }
        byte[] byArray = this.key.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }
}

