/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.asymmetric.RSA;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkPublicKeyDecoder;
import dev.whyoleg.cryptography.providers.jdk.materials.KeysKt;
import dev.whyoleg.cryptography.serialization.asn1.modules.KeyAlgorithmIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.RsaKeyAlgorithmIdentifier;
import dev.whyoleg.cryptography.serialization.pem.PemLabel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPublicKeyDecoder;", "K", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkPublicKeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PublicKey$Format;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "decodeFromBlocking", "format", "input", "", "(Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PublicKey$Format;[B)Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PublicKey;", "cryptography-provider-jdk"})
public abstract class RsaPublicKeyDecoder<K extends RSA.PublicKey>
extends JdkPublicKeyDecoder<RSA.PublicKey.Format, K> {
    public RsaPublicKeyDecoder(@NotNull JdkCryptographyState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(state, "RSA", null, 4, null);
    }

    @NotNull
    public K decodeFromBlocking(@NotNull RSA.PublicKey.Format format, @NotNull byte[] input) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        RSA.PublicKey.Format format2 = format;
        if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.JWK.INSTANCE)) {
            throw new IllegalStateException((format + " is not supported").toString());
        }
        if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.DER.Generic)) {
            byArray = input;
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.PEM.Generic)) {
            byArray = KeysKt.unwrapPem-unSj4pc(PemLabel.Companion.getPublicKey-2EFq_Wg(), input);
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.DER.PKCS1.INSTANCE)) {
            byArray = KeysKt.wrapPublicKey((KeyAlgorithmIdentifier)RsaKeyAlgorithmIdentifier.INSTANCE, input);
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.PEM.PKCS1.INSTANCE)) {
            byArray = KeysKt.wrapPublicKey((KeyAlgorithmIdentifier)RsaKeyAlgorithmIdentifier.INSTANCE, KeysKt.unwrapPem-unSj4pc(PemLabel.Companion.getRsaPublicKey-2EFq_Wg(), input));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (K)((RSA.PublicKey)this.decodeFromDer(byArray));
    }
}

