/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.asymmetric.RSA;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkEncodableKey;
import dev.whyoleg.cryptography.providers.jdk.materials.KeysKt;
import dev.whyoleg.cryptography.serialization.asn1.ObjectIdentifier;
import dev.whyoleg.cryptography.serialization.asn1.modules.KeyAlgorithmIdentifierKt;
import dev.whyoleg.cryptography.serialization.pem.PemLabel;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPublicEncodableKey;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PublicKey$Format;", "key", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "(Ljava/security/PublicKey;)V", "encodeToBlocking", "", "format", "cryptography-provider-jdk"})
public abstract class RsaPublicEncodableKey
extends JdkEncodableKey<RSA.PublicKey.Format> {
    public RsaPublicEncodableKey(@NotNull PublicKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(key, "RSA");
    }

    @NotNull
    public byte[] encodeToBlocking(@NotNull RSA.PublicKey.Format format) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        RSA.PublicKey.Format format2 = format;
        if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.JWK.INSTANCE)) {
            throw new IllegalStateException((format + " is not supported").toString());
        }
        if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.DER.Generic)) {
            byArray = this.encodeToDer();
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.PEM.Generic)) {
            byArray = KeysKt.wrapPem-unSj4pc(PemLabel.Companion.getPublicKey-2EFq_Wg(), this.encodeToDer());
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.DER.PKCS1.INSTANCE)) {
            byArray = KeysKt.unwrapPublicKey-4RESAxk(KeyAlgorithmIdentifierKt.getRSA((ObjectIdentifier.Companion)ObjectIdentifier.Companion), this.encodeToDer());
        } else if (Intrinsics.areEqual((Object)format2, (Object)RSA.PublicKey.Format.PEM.PKCS1.INSTANCE)) {
            byArray = KeysKt.wrapPem-unSj4pc(PemLabel.Companion.getRsaPublicKey-2EFq_Wg(), KeysKt.unwrapPublicKey-4RESAxk(KeyAlgorithmIdentifierKt.getRSA((ObjectIdentifier.Companion)ObjectIdentifier.Companion), this.encodeToDer()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byArray;
    }
}

