/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.BinarySize;
import dev.whyoleg.cryptography.algorithms.asymmetric.RSA;
import dev.whyoleg.cryptography.operations.signature.SignatureGenerator;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaPrivateEncodableKey;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkSignatureGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0011"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPssPrivateKey;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PSS$PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPrivateEncodableKey;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "hashAlgorithmName", "", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PrivateKey;Ljava/lang/String;)V", "signatureGenerator", "Ldev/whyoleg/cryptography/operations/signature/SignatureGenerator;", "saltLength", "Ldev/whyoleg/cryptography/BinarySize;", "signatureGenerator-6q1zMKY", "(I)Ldev/whyoleg/cryptography/operations/signature/SignatureGenerator;", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkRsaPss.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkRsaPss.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/RsaPssPrivateKey\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,123:1\n39#2,5:124\n*S KotlinDebug\n*F\n+ 1 JdkRsaPss.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/RsaPssPrivateKey\n*L\n108#1:124,5\n*E\n"})
final class RsaPssPrivateKey
extends RsaPrivateEncodableKey
implements RSA.PSS.PrivateKey {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PrivateKey key;
    @NotNull
    private final String hashAlgorithmName;

    public RsaPssPrivateKey(@NotNull JdkCryptographyState state, @NotNull PrivateKey key, @NotNull String hashAlgorithmName) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithmName, (String)"hashAlgorithmName");
        super(key);
        this.state = state;
        this.key = key;
        this.hashAlgorithmName = hashAlgorithmName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SignatureGenerator signatureGenerator() {
        int n;
        Pooled<MessageDigest> this_$iv = this.state.messageDigest(this.hashAlgorithmName);
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$get(this_$iv);
        try {
            MessageDigest it = (MessageDigest)instance$iv;
            boolean bl = false;
            n = it.getDigestLength();
        }
        finally {
            Pooled.access$put(this_$iv, instance$iv);
        }
        int digestSize = n;
        return this.signatureGenerator-6q1zMKY(BinarySize.Companion.getBytes-M1VWhS4(digestSize));
    }

    @NotNull
    public SignatureGenerator signatureGenerator-6q1zMKY(int saltLength) {
        PSSParameterSpec parameters = new PSSParameterSpec(this.hashAlgorithmName, "MGF1", new MGF1ParameterSpec(this.hashAlgorithmName), BinarySize.getInBytes-impl((int)saltLength), 1);
        return new JdkSignatureGenerator(this.state, this.key, "RSASSA-PSS", parameters);
    }
}

