/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.asymmetric.RSA;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaPssPrivateKey;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaPssPublicKey;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPssKeyPair;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PSS$KeyPair;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "keyPair", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "hashAlgorithmName", "", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/KeyPair;Ljava/lang/String;)V", "privateKey", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PSS$PrivateKey;", "getPrivateKey", "()Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PSS$PrivateKey;", "publicKey", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PSS$PublicKey;", "getPublicKey", "()Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PSS$PublicKey;", "cryptography-provider-jdk"})
final class RsaPssKeyPair
implements RSA.PSS.KeyPair {
    @NotNull
    private final RSA.PSS.PublicKey publicKey;
    @NotNull
    private final RSA.PSS.PrivateKey privateKey;

    public RsaPssKeyPair(@NotNull JdkCryptographyState state, @NotNull KeyPair keyPair, @NotNull String hashAlgorithmName) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithmName, (String)"hashAlgorithmName");
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        this.publicKey = new RsaPssPublicKey(state, publicKey, hashAlgorithmName);
        PrivateKey privateKey = keyPair.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        this.privateKey = new RsaPssPrivateKey(state, privateKey, hashAlgorithmName);
    }

    @NotNull
    public RSA.PSS.PublicKey getPublicKey() {
        return this.publicKey;
    }

    @NotNull
    public RSA.PSS.PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

