/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.asymmetric.RSA;
import dev.whyoleg.cryptography.operations.cipher.AuthenticatedEncryptor;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaOaepEncryptor;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaPublicEncodableKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\rH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaOaepPublicKey;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$OAEP$PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPublicEncodableKey;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "hashAlgorithmName", "", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PublicKey;Ljava/lang/String;)V", "encryptor", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaOaepEncryptor;", "Ldev/whyoleg/cryptography/operations/cipher/AuthenticatedEncryptor;", "cryptography-provider-jdk"})
final class RsaOaepPublicKey
extends RsaPublicEncodableKey
implements RSA.OAEP.PublicKey {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PublicKey key;
    @NotNull
    private final RsaOaepEncryptor encryptor;

    public RsaOaepPublicKey(@NotNull JdkCryptographyState state, @NotNull PublicKey key, @NotNull String hashAlgorithmName) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithmName, (String)"hashAlgorithmName");
        super(key);
        this.state = state;
        this.key = key;
        this.encryptor = new RsaOaepEncryptor(this.state, this.key, hashAlgorithmName);
    }

    @NotNull
    public AuthenticatedEncryptor encryptor() {
        return this.encryptor;
    }
}

