/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.BinarySize;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.algorithms.asymmetric.RSA;
import dev.whyoleg.cryptography.algorithms.digest.Digest;
import dev.whyoleg.cryptography.bigint.BigInt;
import dev.whyoleg.cryptography.bigint.BigIntKt;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyGenerator;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkRsaKt;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaOaepKeyPairGenerator;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaOaepPrivateKeyDecoder;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaOaepPublicKeyDecoder;
import java.security.spec.RSAKeyGenParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\"\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0018"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkRsaOaep;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$OAEP;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "keyPairGenerator", "Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$OAEP$KeyPair;", "keySize", "Ldev/whyoleg/cryptography/BinarySize;", "digest", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "Ldev/whyoleg/cryptography/algorithms/digest/Digest;", "publicExponent", "Ldev/whyoleg/cryptography/bigint/BigInt;", "keyPairGenerator-imL9hLU", "(ILdev/whyoleg/cryptography/CryptographyAlgorithmId;Ldev/whyoleg/cryptography/bigint/BigInt;)Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "privateKeyDecoder", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PrivateKey$Format;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$OAEP$PrivateKey;", "publicKeyDecoder", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PublicKey$Format;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$OAEP$PublicKey;", "cryptography-provider-jdk"})
public final class JdkRsaOaep
implements RSA.OAEP {
    @NotNull
    private final JdkCryptographyState state;

    public JdkRsaOaep(@NotNull JdkCryptographyState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @NotNull
    public KeyDecoder<RSA.PublicKey.Format, RSA.OAEP.PublicKey> publicKeyDecoder(@NotNull CryptographyAlgorithmId<Digest> digest) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        return new RsaOaepPublicKeyDecoder(this.state, JdkRsaKt.rsaHashAlgorithmName(digest));
    }

    @NotNull
    public KeyDecoder<RSA.PrivateKey.Format, RSA.OAEP.PrivateKey> privateKeyDecoder(@NotNull CryptographyAlgorithmId<Digest> digest) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        return new RsaOaepPrivateKeyDecoder(this.state, JdkRsaKt.rsaHashAlgorithmName(digest));
    }

    @NotNull
    public KeyGenerator<RSA.OAEP.KeyPair> keyPairGenerator-imL9hLU(int keySize, @NotNull CryptographyAlgorithmId<Digest> digest, @NotNull BigInt publicExponent) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)publicExponent, (String)"publicExponent");
        RSAKeyGenParameterSpec rsaParameters = new RSAKeyGenParameterSpec(BinarySize.getInBits-impl((int)keySize), BigIntKt.toJavaBigInteger((BigInt)publicExponent));
        return new RsaOaepKeyPairGenerator(this.state, rsaParameters, JdkRsaKt.rsaHashAlgorithmName(digest));
    }
}

