/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.algorithms.digest.Digest;
import dev.whyoleg.cryptography.algorithms.symmetric.HMAC;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyGenerator;
import dev.whyoleg.cryptography.operations.signature.SignatureGenerator;
import dev.whyoleg.cryptography.operations.signature.SignatureVerifier;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyStateKt;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkHmac;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkHmacKt;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkSecretKeyDecoder;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkSecretKeyGenerator;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkMacSignature;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkHmac;", "Ldev/whyoleg/cryptography/algorithms/symmetric/HMAC;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "keyWrapper", "Lkotlin/Function1;", "Ljavax/crypto/SecretKey;", "Ldev/whyoleg/cryptography/providers/jdk/JSecretKey;", "Ldev/whyoleg/cryptography/algorithms/symmetric/HMAC$Key;", "keyDecoder", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/symmetric/HMAC$Key$Format;", "digest", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "Ldev/whyoleg/cryptography/algorithms/digest/Digest;", "keyGenerator", "Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "cryptography-provider-jdk"})
public final class JdkHmac
implements HMAC {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final Function1<SecretKey, HMAC.Key> keyWrapper;

    public JdkHmac(@NotNull JdkCryptographyState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.keyWrapper = (Function1)new Function1<SecretKey, keyWrapper.1>(this){
            final /* synthetic */ JdkHmac this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final keyWrapper.1 invoke(@NotNull SecretKey key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return new HMAC.Key(this.this$0, key){
                    @NotNull
                    private final JdkMacSignature signature;
                    {
                        super($key, null, 2, null);
                        JdkCryptographyState jdkCryptographyState = JdkHmac.access$getState$p($receiver);
                        String string = $key.getAlgorithm();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAlgorithm(...)");
                        this.signature = new JdkMacSignature(jdkCryptographyState, $key, string);
                    }

                    @NotNull
                    public SignatureGenerator signatureGenerator() {
                        return this.signature;
                    }

                    @NotNull
                    public SignatureVerifier signatureVerifier() {
                        return this.signature;
                    }

                    @NotNull
                    public byte[] encodeToBlocking(@NotNull HMAC.Key.Format format) {
                        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                        switch (keyWrapper.WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                            case 1: {
                                throw new IllegalStateException((format + " is not supported").toString());
                            }
                            case 2: {
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        return this.encodeToRaw();
                    }
                };
            }
        };
    }

    @NotNull
    public KeyDecoder<HMAC.Key.Format, HMAC.Key> keyDecoder(@NotNull CryptographyAlgorithmId<Digest> digest) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        return new JdkSecretKeyDecoder("Hmac" + JdkCryptographyStateKt.hashAlgorithmName(digest), this.keyWrapper);
    }

    @NotNull
    public KeyGenerator<HMAC.Key> keyGenerator(@NotNull CryptographyAlgorithmId<Digest> digest) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        int blockSize = JdkHmacKt.access$blockSize(digest);
        return new JdkSecretKeyGenerator<HMAC.Key>(this.state, "Hmac" + JdkCryptographyStateKt.hashAlgorithmName(digest), this.keyWrapper, (Function1<? super javax.crypto.KeyGenerator, Unit>)((Function1)new Function1<javax.crypto.KeyGenerator, Unit>(blockSize, this){
            final /* synthetic */ int $blockSize;
            final /* synthetic */ JdkHmac this$0;
            {
                this.$blockSize = $blockSize;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull javax.crypto.KeyGenerator $this$$receiver) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                $this$$receiver.init(this.$blockSize, JdkHmac.access$getState$p(this.this$0).getSecureRandom());
            }
        }));
    }

    public static final /* synthetic */ JdkCryptographyState access$getState$p(JdkHmac $this) {
        return $this.state;
    }
}

