/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.asymmetric.ECDSA;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.EcdsaKeyPair;
import dev.whyoleg.cryptography.providers.jdk.algorithms.EcdsaPrivateKey;
import dev.whyoleg.cryptography.providers.jdk.algorithms.EcdsaPublicKey;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkEc;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u0004*\u00060\nj\u0002`\u000bH\u0014J\u0010\u0010\t\u001a\u00020\u0003*\u00060\fj\u0002`\rH\u0014J\u0010\u0010\t\u001a\u00020\u0002*\u00060\u000ej\u0002`\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdsa;", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/ECDSA$PublicKey;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/ECDSA$PrivateKey;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/ECDSA$KeyPair;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/ECDSA;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "convert", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "cryptography-provider-jdk"})
public final class JdkEcdsa
extends JdkEc<ECDSA.PublicKey, ECDSA.PrivateKey, ECDSA.KeyPair>
implements ECDSA {
    public JdkEcdsa(@NotNull JdkCryptographyState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(state, null);
    }

    @Override
    @NotNull
    protected ECDSA.PublicKey convert(@NotNull PublicKey $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        return new EcdsaPublicKey(this.getState(), $this$convert);
    }

    @Override
    @NotNull
    protected ECDSA.PrivateKey convert(@NotNull PrivateKey $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        return new EcdsaPrivateKey(this.getState(), $this$convert);
    }

    @Override
    @NotNull
    protected ECDSA.KeyPair convert(@NotNull KeyPair $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        PublicKey publicKey = $this$convert.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublic(...)");
        ECDSA.PublicKey publicKey2 = this.convert(publicKey);
        PrivateKey privateKey = $this$convert.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        return new EcdsaKeyPair(publicKey2, this.convert(privateKey));
    }
}

