/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.asymmetric.EC;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyGenerator;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkKeyPairGenerator;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkPrivateKeyDecoder;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkPublicKeyDecoder;
import dev.whyoleg.cryptography.providers.jdk.materials.KeysKt;
import dev.whyoleg.cryptography.serialization.pem.PemLabel;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\u0014\b\u0002\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007:\u0003012B\u000f\b\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ$\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00028\u00010\u001f2\u0006\u0010\u001b\u001a\u00020\u0013\u00f8\u0001\u0000\u00a2\u0006\u0004\b!\u0010\"J$\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00028\u00000\u001f2\u0006\u0010\u001b\u001a\u00020\u0013\u00f8\u0001\u0000\u00a2\u0006\u0004\b%\u0010\"J\u0015\u0010&\u001a\u00028\u0002*\u00060'j\u0002`(H$\u00a2\u0006\u0002\u0010)J\u0015\u0010&\u001a\u00028\u0001*\u00060*j\u0002`+H$\u00a2\u0006\u0002\u0010,J\u0015\u0010&\u001a\u00028\u0000*\u00060-j\u0002`.H$\u00a2\u0006\u0002\u0010/R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u00013\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00064"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc;", "PublicK", "Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PublicKey;", "PrivateK", "Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PrivateKey;", "KP", "Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$KeyPair;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/EC;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "algorithmParameters", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljava/security/AlgorithmParameters;", "Ldev/whyoleg/cryptography/providers/jdk/JAlgorithmParameters;", "getState", "()Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "jdkName", "", "Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$Curve;", "getJdkName-EsXthJ8", "(Ljava/lang/String;)Ljava/lang/String;", "curveName", "params", "Ljava/security/spec/AlgorithmParameterSpec;", "keyPairGenerator", "Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "curve", "keyPairGenerator-EsXthJ8", "(Ljava/lang/String;)Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "privateKeyDecoder", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PrivateKey$Format;", "privateKeyDecoder-EsXthJ8", "(Ljava/lang/String;)Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "publicKeyDecoder", "Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PublicKey$Format;", "publicKeyDecoder-EsXthJ8", "convert", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "(Ljava/security/KeyPair;)Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$KeyPair;", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "(Ljava/security/PrivateKey;)Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PrivateKey;", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "(Ljava/security/PublicKey;)Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PublicKey;", "EcKeyPairGenerator", "EcPrivateKeyDecoder", "EcPublicKeyDecoder", "Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEcdsa;", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkEc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,115:1\n39#2,5:116\n*S KotlinDebug\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc\n*L\n21#1:116,5\n*E\n"})
public abstract class JdkEc<PublicK extends EC.PublicKey, PrivateK extends EC.PrivateKey, KP extends EC.KeyPair<PublicK, PrivateK>>
implements EC<PublicK, PrivateK, KP> {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final Pooled<AlgorithmParameters> algorithmParameters;

    private JdkEc(JdkCryptographyState state) {
        this.state = state;
        this.algorithmParameters = this.state.algorithmParameters("EC");
    }

    @NotNull
    protected final JdkCryptographyState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String curveName(AlgorithmParameterSpec params) {
        String string;
        Pooled<AlgorithmParameters> this_$iv = this.algorithmParameters;
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$get(this_$iv);
        try {
            AlgorithmParameters it = (AlgorithmParameters)instance$iv;
            boolean bl = false;
            it.init(params);
            String string2 = it.getParameterSpec(ECGenParameterSpec.class).getName();
            string = string2;
        }
        finally {
            Pooled.access$put(this_$iv, instance$iv);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"use(...)");
        return string;
    }

    @NotNull
    protected abstract PublicK convert(@NotNull PublicKey var1);

    @NotNull
    protected abstract PrivateK convert(@NotNull PrivateKey var1);

    @NotNull
    protected abstract KP convert(@NotNull KeyPair var1);

    @NotNull
    public final KeyDecoder<EC.PublicKey.Format, PublicK> publicKeyDecoder-EsXthJ8(@NotNull String curve) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        return new EcPublicKeyDecoder(this.curveName(new ECGenParameterSpec(this.getJdkName-EsXthJ8(curve))));
    }

    @NotNull
    public final KeyDecoder<EC.PrivateKey.Format, PrivateK> privateKeyDecoder-EsXthJ8(@NotNull String curve) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        return new EcPrivateKeyDecoder(this.curveName(new ECGenParameterSpec(this.getJdkName-EsXthJ8(curve))));
    }

    @NotNull
    public final KeyGenerator<KP> keyPairGenerator-EsXthJ8(@NotNull String curve) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        return new EcKeyPairGenerator(new ECGenParameterSpec(this.getJdkName-EsXthJ8(curve)));
    }

    private final String getJdkName-EsXthJ8(String $this$jdkName) {
        String string = $this$jdkName;
        return EC.Curve.equals-impl0((String)string, (String)EC.Curve.Companion.getP256-cLhQC20()) ? "secp256r1" : (EC.Curve.equals-impl0((String)string, (String)EC.Curve.Companion.getP384-cLhQC20()) ? "secp384r1" : (EC.Curve.equals-impl0((String)string, (String)EC.Curve.Companion.getP521-cLhQC20()) ? "secp521r1" : $this$jdkName));
    }

    public /* synthetic */ JdkEc(JdkCryptographyState state, DefaultConstructorMarker $constructor_marker) {
        this(state);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00028\u0002*\u00060\u0006j\u0002`\u0007H\u0014\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n*\u00060\u000bj\u0002`\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcKeyPairGenerator;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkKeyPairGenerator;", "keyGenParameters", "Ljava/security/spec/ECGenParameterSpec;", "(Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc;Ljava/security/spec/ECGenParameterSpec;)V", "convert", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "(Ljava/security/KeyPair;)Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$KeyPair;", "init", "", "Ljava/security/KeyPairGenerator;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPairGenerator;", "cryptography-provider-jdk"})
    @SourceDebugExtension(value={"SMAP\nJdkEc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcKeyPairGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
    private final class EcKeyPairGenerator
    extends JdkKeyPairGenerator<KP> {
        @NotNull
        private final ECGenParameterSpec keyGenParameters;

        public EcKeyPairGenerator(ECGenParameterSpec keyGenParameters) {
            Intrinsics.checkNotNullParameter((Object)keyGenParameters, (String)"keyGenParameters");
            super(JdkEc.this.getState(), "EC");
            this.keyGenParameters = keyGenParameters;
        }

        @Override
        protected void init(@NotNull KeyPairGenerator $this$init) {
            Intrinsics.checkNotNullParameter((Object)$this$init, (String)"<this>");
            $this$init.initialize(this.keyGenParameters, this.getState().getSecureRandom());
        }

        @Override
        @NotNull
        protected KP convert(@NotNull KeyPair $this$convert) {
            Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
            JdkEc $this$convert_u24lambda_u240 = JdkEc.this;
            boolean bl = false;
            return $this$convert_u24lambda_u240.convert($this$convert);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00010\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u0001*\u00060\fj\u0002`\rH\u0014\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcPrivateKeyDecoder;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkPrivateKeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PrivateKey$Format;", "curveName", "", "(Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc;Ljava/lang/String;)V", "decodeFromBlocking", "format", "input", "", "(Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PrivateKey$Format;[B)Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PrivateKey;", "convert", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "(Ljava/security/PrivateKey;)Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PrivateKey;", "cryptography-provider-jdk"})
    @SourceDebugExtension(value={"SMAP\nJdkEc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcPrivateKeyDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
    private final class EcPrivateKeyDecoder
    extends JdkPrivateKeyDecoder<EC.PrivateKey.Format, PrivateK> {
        @NotNull
        private final String curveName;

        public EcPrivateKeyDecoder(String curveName) {
            Intrinsics.checkNotNullParameter((Object)curveName, (String)"curveName");
            super(JdkEc.this.getState(), "EC", null, 4, null);
            this.curveName = curveName;
        }

        @Override
        @NotNull
        protected PrivateK convert(@NotNull PrivateKey $this$convert) {
            Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
            if (!($this$convert instanceof ECPrivateKey)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            ECParameterSpec eCParameterSpec = ((ECPrivateKey)$this$convert).getParams();
            Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"getParams(...)");
            String keyCurve = JdkEc.this.curveName(eCParameterSpec);
            if (!Intrinsics.areEqual((Object)this.curveName, (Object)keyCurve)) {
                boolean $i$a$-check-JdkEc$EcPrivateKeyDecoder$convert$22 = false;
                String $i$a$-check-JdkEc$EcPrivateKeyDecoder$convert$22 = "Key curve " + keyCurve + " is not equal to expected curve " + this.curveName;
                throw new IllegalStateException($i$a$-check-JdkEc$EcPrivateKeyDecoder$convert$22.toString());
            }
            JdkEc $this$convert_u24lambda_u241 = JdkEc.this;
            boolean bl = false;
            return $this$convert_u24lambda_u241.convert($this$convert);
        }

        @NotNull
        public PrivateK decodeFromBlocking(@NotNull EC.PrivateKey.Format format, @NotNull byte[] input) {
            EC.PrivateKey privateKey;
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1: {
                    throw new IllegalStateException((format + " is not supported").toString());
                }
                case 2: {
                    privateKey = (EC.PrivateKey)this.decodeFromDer(input);
                    break;
                }
                case 3: {
                    privateKey = (EC.PrivateKey)this.decodeFromDer(KeysKt.unwrapPem-unSj4pc(PemLabel.Companion.getPrivateKey-2EFq_Wg(), input));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return privateKey;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EC.PrivateKey.Format.values().length];
                try {
                    nArray[EC.PrivateKey.Format.JWK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EC.PrivateKey.Format.DER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EC.PrivateKey.Format.PEM.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00000\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u0000*\u00060\fj\u0002`\rH\u0014\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcPublicKeyDecoder;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkPublicKeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PublicKey$Format;", "curveName", "", "(Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc;Ljava/lang/String;)V", "decodeFromBlocking", "format", "input", "", "(Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PublicKey$Format;[B)Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PublicKey;", "convert", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "(Ljava/security/PublicKey;)Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PublicKey;", "cryptography-provider-jdk"})
    @SourceDebugExtension(value={"SMAP\nJdkEc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcPublicKeyDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,115:1\n1#2:116\n39#3,5:117\n39#3,5:122\n*S KotlinDebug\n*F\n+ 1 JdkEc.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkEc$EcPublicKeyDecoder\n*L\n76#1:117,5\n87#1:122,5\n*E\n"})
    private final class EcPublicKeyDecoder
    extends JdkPublicKeyDecoder<EC.PublicKey.Format, PublicK> {
        @NotNull
        private final String curveName;

        public EcPublicKeyDecoder(String curveName) {
            Intrinsics.checkNotNullParameter((Object)curveName, (String)"curveName");
            super(JdkEc.this.getState(), "EC", null, 4, null);
            this.curveName = curveName;
        }

        @Override
        @NotNull
        protected PublicK convert(@NotNull PublicKey $this$convert) {
            Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
            if (!($this$convert instanceof ECPublicKey)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            ECParameterSpec eCParameterSpec = ((ECPublicKey)$this$convert).getParams();
            Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"getParams(...)");
            String keyCurve = JdkEc.this.curveName(eCParameterSpec);
            if (!Intrinsics.areEqual((Object)this.curveName, (Object)keyCurve)) {
                boolean $i$a$-check-JdkEc$EcPublicKeyDecoder$convert$22 = false;
                String $i$a$-check-JdkEc$EcPublicKeyDecoder$convert$22 = "Key curve " + keyCurve + " is not equal to expected curve " + this.curveName;
                throw new IllegalStateException($i$a$-check-JdkEc$EcPublicKeyDecoder$convert$22.toString());
            }
            JdkEc $this$convert_u24lambda_u241 = JdkEc.this;
            boolean bl = false;
            return $this$convert_u24lambda_u241.convert($this$convert);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public PublicK decodeFromBlocking(@NotNull EC.PublicKey.Format format, @NotNull byte[] input) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1: {
                    throw new IllegalStateException((format + " is not supported").toString());
                }
                case 2: {
                    PublicKey publicKey;
                    void this_$iv;
                    Object it322;
                    if (!(!(input.length == 0) && input[0] == 4)) {
                        boolean $i$a$-check-JdkEc$EcPublicKeyDecoder$decodeFromBlocking$32 = false;
                        String $i$a$-check-JdkEc$EcPublicKeyDecoder$decodeFromBlocking$32 = "Encoded key should be in uncompressed format";
                        throw new IllegalStateException($i$a$-check-JdkEc$EcPublicKeyDecoder$decodeFromBlocking$32.toString());
                    }
                    Pooled this_$iv2 = JdkEc.this.algorithmParameters;
                    boolean $i$f$use = false;
                    Object instance$iv = Pooled.access$get(this_$iv2);
                    try {
                        it322 = (AlgorithmParameters)instance$iv;
                        boolean bl = false;
                        ((AlgorithmParameters)it322).init(new ECGenParameterSpec(this.curveName));
                        it322 = ((AlgorithmParameters)it322).getParameterSpec(ECParameterSpec.class);
                    }
                    finally {
                        Pooled.access$put(this_$iv2, instance$iv);
                    }
                    Object parameters = it322;
                    int fieldSize = (((ECParameterSpec)parameters).getCurve().getField().getFieldSize() + 7) / 8;
                    if (!(input.length == fieldSize * 2 + 1)) {
                        boolean $i$a$-check-JdkEc$EcPublicKeyDecoder$decodeFromBlocking$42 = false;
                        String $i$a$-check-JdkEc$EcPublicKeyDecoder$decodeFromBlocking$42 = "Wrong encoded key size";
                        throw new IllegalStateException($i$a$-check-JdkEc$EcPublicKeyDecoder$decodeFromBlocking$42.toString());
                    }
                    byte[] $i$a$-check-JdkEc$EcPublicKeyDecoder$decodeFromBlocking$42 = input;
                    int it322 = 1;
                    int n = fieldSize + 1;
                    byte[] x = ArraysKt.copyOfRange((byte[])$i$a$-check-JdkEc$EcPublicKeyDecoder$decodeFromBlocking$42, (int)it322, (int)n);
                    byte[] it322 = input;
                    n = fieldSize + 1;
                    int n2 = fieldSize + 1 + fieldSize;
                    byte[] y = ArraysKt.copyOfRange((byte[])it322, (int)n, (int)n2);
                    ECPoint point = new ECPoint(new BigInteger(1, x), new BigInteger(1, y));
                    Pooled<KeyFactory> pooled = this.getKeyFactory();
                    EcPublicKeyDecoder ecPublicKeyDecoder = this;
                    boolean $i$f$use2 = false;
                    Object instance$iv2 = Pooled.access$get((Pooled)this_$iv);
                    try {
                        KeyFactory it = (KeyFactory)instance$iv2;
                        boolean bl = false;
                        publicKey = it.generatePublic(new ECPublicKeySpec(point, (ECParameterSpec)parameters));
                    }
                    finally {
                        Pooled.access$put((Pooled)this_$iv, instance$iv2);
                    }
                    PublicKey publicKey2 = publicKey;
                    Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"use(...)");
                    object = ecPublicKeyDecoder.convert(publicKey2);
                    break;
                }
                case 3: {
                    object = (EC.PublicKey)this.decodeFromDer(input);
                    break;
                }
                case 4: {
                    object = (EC.PublicKey)this.decodeFromDer(KeysKt.unwrapPem-unSj4pc(PemLabel.Companion.getPublicKey-2EFq_Wg(), input));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return object;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EC.PublicKey.Format.values().length];
                try {
                    nArray[EC.PublicKey.Format.JWK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EC.PublicKey.Format.RAW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EC.PublicKey.Format.DER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EC.PublicKey.Format.PEM.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

