/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.algorithms.digest.Digest;
import dev.whyoleg.cryptography.operations.hash.Hasher;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0001H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkDigest;", "Ldev/whyoleg/cryptography/operations/hash/Hasher;", "Ldev/whyoleg/cryptography/algorithms/digest/Digest;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "algorithm", "", "id", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/lang/String;Ldev/whyoleg/cryptography/CryptographyAlgorithmId;)V", "getId", "()Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "messageDigest", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljava/security/MessageDigest;", "Ldev/whyoleg/cryptography/providers/jdk/JMessageDigest;", "hashBlocking", "", "dataInput", "hasher", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkDigest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkDigest.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkDigest\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,26:1\n39#2,5:27\n*S KotlinDebug\n*F\n+ 1 JdkDigest.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/JdkDigest\n*L\n21#1:27,5\n*E\n"})
public final class JdkDigest
implements Hasher,
Digest {
    @NotNull
    private final CryptographyAlgorithmId<Digest> id;
    @NotNull
    private final Pooled<MessageDigest> messageDigest;

    public JdkDigest(@NotNull JdkCryptographyState state, @NotNull String algorithm, @NotNull CryptographyAlgorithmId<Digest> id) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        this.id = id;
        this.messageDigest = state.messageDigest(algorithm);
    }

    @NotNull
    public CryptographyAlgorithmId<Digest> getId() {
        return this.id;
    }

    @NotNull
    public Hasher hasher() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] hashBlocking(@NotNull byte[] dataInput) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)dataInput, (String)"dataInput");
        Pooled<MessageDigest> this_$iv = this.messageDigest;
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$get(this_$iv);
        try {
            MessageDigest messageDigest = (MessageDigest)instance$iv;
            boolean bl = false;
            messageDigest.reset();
            byArray = messageDigest.digest(dataInput);
        }
        finally {
            Pooled.access$put(this_$iv, instance$iv);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }
}

