/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.BinarySize;
import dev.whyoleg.cryptography.algorithms.symmetric.AES;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyGenerator;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.AesCbcCipher;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkAesCbc;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkSecretKeyDecoder;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkSecretKeyGenerator;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\rH\u0016J \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0014"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/JdkAesCbc;", "Ldev/whyoleg/cryptography/algorithms/symmetric/AES$CBC;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;)V", "keyDecoder", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkSecretKeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/symmetric/AES$Key$Format;", "Ldev/whyoleg/cryptography/algorithms/symmetric/AES$CBC$Key;", "keyWrapper", "Lkotlin/Function1;", "Ljavax/crypto/SecretKey;", "Ldev/whyoleg/cryptography/providers/jdk/JSecretKey;", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "keyGenerator", "Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "keySize", "Ldev/whyoleg/cryptography/algorithms/symmetric/SymmetricKeySize;", "keyGenerator-__FLmac", "(I)Ldev/whyoleg/cryptography/materials/key/KeyGenerator;", "cryptography-provider-jdk"})
public final class JdkAesCbc
implements AES.CBC {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final Function1<SecretKey, AES.CBC.Key> keyWrapper;
    @NotNull
    private final JdkSecretKeyDecoder<AES.Key.Format, AES.CBC.Key> keyDecoder;

    public JdkAesCbc(@NotNull JdkCryptographyState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.keyWrapper = (Function1)new Function1<SecretKey, keyWrapper.1>(this){
            final /* synthetic */ JdkAesCbc this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final keyWrapper.1 invoke(@NotNull SecretKey key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return new AES.CBC.Key(key, this.this$0){
                    final /* synthetic */ SecretKey $key;
                    final /* synthetic */ JdkAesCbc this$0;
                    {
                        this.$key = $key;
                        this.this$0 = $receiver;
                        super($key, null, 2, null);
                    }

                    @NotNull
                    public AES.CBC.Cipher cipher(boolean padding) {
                        return new AesCbcCipher(JdkAesCbc.access$getState$p(this.this$0), this.$key, padding);
                    }

                    @NotNull
                    public byte[] encodeToBlocking(@NotNull AES.Key.Format format) {
                        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                        switch (keyWrapper.WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                            case 1: {
                                throw new IllegalStateException((format + " is not supported").toString());
                            }
                            case 2: {
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        return this.encodeToRaw();
                    }
                };
            }
        };
        this.keyDecoder = new JdkSecretKeyDecoder("AES", this.keyWrapper);
    }

    @NotNull
    public KeyDecoder<AES.Key.Format, AES.CBC.Key> keyDecoder() {
        return this.keyDecoder;
    }

    @NotNull
    public KeyGenerator<AES.CBC.Key> keyGenerator-__FLmac(int keySize) {
        return new JdkSecretKeyGenerator<AES.CBC.Key>(this.state, "AES", this.keyWrapper, (Function1<? super javax.crypto.KeyGenerator, Unit>)((Function1)new Function1<javax.crypto.KeyGenerator, Unit>(keySize, this){
            final /* synthetic */ int $keySize;
            final /* synthetic */ JdkAesCbc this$0;
            {
                this.$keySize = $keySize;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull javax.crypto.KeyGenerator $this$$receiver) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                $this$$receiver.init(BinarySize.getInBits-impl((int)this.$keySize), JdkAesCbc.access$getState$p(this.this$0).getSecureRandom());
            }
        }));
    }

    public static final /* synthetic */ JdkCryptographyState access$getState$p(JdkAesCbc $this) {
        return $this.state;
    }
}

