/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.BinarySize;
import dev.whyoleg.cryptography.operations.cipher.AuthenticatedCipher;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0016R\u0018\u0010\n\u001a\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u000e\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/AesGcmCipher;", "Ldev/whyoleg/cryptography/operations/cipher/AuthenticatedCipher;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljavax/crypto/SecretKey;", "Ldev/whyoleg/cryptography/providers/jdk/JSecretKey;", "tagSize", "Ldev/whyoleg/cryptography/BinarySize;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljavax/crypto/SecretKey;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "cipher", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/Cipher;", "Ldev/whyoleg/cryptography/providers/jdk/JCipher;", "I", "decryptBlocking", "", "ciphertextInput", "associatedData", "encryptBlocking", "plaintextInput", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkAesGcm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkAesGcm.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/AesGcmCipher\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n39#2,3:60\n43#2:64\n39#2,5:65\n1#3:63\n*S KotlinDebug\n*F\n+ 1 JdkAesGcm.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/AesGcmCipher\n*L\n46#1:60,3\n46#1:64\n53#1:65,5\n*E\n"})
final class AesGcmCipher
implements AuthenticatedCipher {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final SecretKey key;
    private final int tagSize;
    @NotNull
    private final Pooled<Cipher> cipher;

    private AesGcmCipher(JdkCryptographyState state, SecretKey key, int tagSize) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.state = state;
        this.key = key;
        this.tagSize = tagSize;
        this.cipher = this.state.cipher("AES/GCM/NoPadding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] encryptBlocking(@NotNull byte[] plaintextInput, @Nullable byte[] associatedData) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)plaintextInput, (String)"plaintextInput");
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$get(this_$iv);
        try {
            Cipher cipher = (Cipher)instance$iv;
            boolean bl = false;
            byte[] byArray2 = new byte[12];
            SecureRandom secureRandom = this.state.getSecureRandom();
            byte[] p0 = byArray2;
            boolean bl2 = false;
            secureRandom.nextBytes(p0);
            byte[] iv = byArray2;
            cipher.init(1, (Key)this.key, new GCMParameterSpec(BinarySize.getInBits-impl((int)this.tagSize), iv), this.state.getSecureRandom());
            if (associatedData != null) {
                byte[] p02 = associatedData;
                boolean bl3 = false;
                cipher.updateAAD(p02);
            }
            byte[] byArray3 = cipher.doFinal(plaintextInput);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"doFinal(...)");
            byArray = ArraysKt.plus((byte[])iv, (byte[])byArray3);
        }
        finally {
            Pooled.access$put(this_$iv, instance$iv);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] decryptBlocking(@NotNull byte[] ciphertextInput, @Nullable byte[] associatedData) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)ciphertextInput, (String)"ciphertextInput");
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$get(this_$iv);
        try {
            Cipher cipher = (Cipher)instance$iv;
            boolean bl = false;
            cipher.init(2, (Key)this.key, new GCMParameterSpec(BinarySize.getInBits-impl((int)this.tagSize), ciphertextInput, 0, 12), this.state.getSecureRandom());
            if (associatedData != null) {
                byte[] p0 = associatedData;
                boolean bl2 = false;
                cipher.updateAAD(p0);
            }
            byArray = cipher.doFinal(ciphertextInput, 12, ciphertextInput.length - 12);
        }
        finally {
            Pooled.access$put(this_$iv, instance$iv);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    public /* synthetic */ AesGcmCipher(JdkCryptographyState state, SecretKey key, int tagSize, DefaultConstructorMarker $constructor_marker) {
        this(state, key, tagSize);
    }
}

