/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.DelicateCryptographyApi;
import dev.whyoleg.cryptography.algorithms.symmetric.AES;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0017J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0017R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/AesCtrCipher;", "Ldev/whyoleg/cryptography/algorithms/symmetric/AES$CTR$Cipher;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljavax/crypto/SecretKey;", "Ldev/whyoleg/cryptography/providers/jdk/JSecretKey;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljavax/crypto/SecretKey;)V", "cipher", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/Cipher;", "Ldev/whyoleg/cryptography/providers/jdk/JCipher;", "decryptBlocking", "", "ciphertextInput", "iv", "encryptBlocking", "plaintextInput", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkAesCtr.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkAesCtr.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/AesCtrCipher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,64:1\n1#2:65\n39#3,5:66\n39#3,5:71\n39#3,5:76\n*S KotlinDebug\n*F\n+ 1 JdkAesCtr.kt\ndev/whyoleg/cryptography/providers/jdk/algorithms/AesCtrCipher\n*L\n48#1:66,5\n53#1:71,5\n59#1:76,5\n*E\n"})
final class AesCtrCipher
implements AES.CTR.Cipher {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final SecretKey key;
    @NotNull
    private final Pooled<Cipher> cipher;

    public AesCtrCipher(@NotNull JdkCryptographyState state, @NotNull SecretKey key) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.state = state;
        this.key = key;
        this.cipher = this.state.cipher("AES/CTR/NoPadding");
    }

    @NotNull
    public byte[] encryptBlocking(@NotNull byte[] plaintextInput) {
        Intrinsics.checkNotNullParameter((Object)plaintextInput, (String)"plaintextInput");
        byte[] byArray = new byte[16];
        SecureRandom secureRandom = this.state.getSecureRandom();
        byte[] p0 = byArray;
        boolean bl = false;
        secureRandom.nextBytes(p0);
        byte[] iv = byArray;
        return ArraysKt.plus((byte[])iv, (byte[])this.encryptBlocking(iv, plaintextInput));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DelicateCryptographyApi
    @NotNull
    public byte[] encryptBlocking(@NotNull byte[] iv, @NotNull byte[] plaintextInput) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)plaintextInput, (String)"plaintextInput");
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$get(this_$iv);
        try {
            Cipher cipher = (Cipher)instance$iv;
            boolean bl = false;
            cipher.init(1, (Key)this.key, new IvParameterSpec(iv), this.state.getSecureRandom());
            byArray = cipher.doFinal(plaintextInput);
        }
        finally {
            Pooled.access$put(this_$iv, instance$iv);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] decryptBlocking(@NotNull byte[] ciphertextInput) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)ciphertextInput, (String)"ciphertextInput");
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$get(this_$iv);
        try {
            Cipher cipher = (Cipher)instance$iv;
            boolean bl = false;
            cipher.init(2, (Key)this.key, new IvParameterSpec(ciphertextInput, 0, 16), this.state.getSecureRandom());
            byArray = cipher.doFinal(ciphertextInput, 16, ciphertextInput.length - 16);
        }
        finally {
            Pooled.access$put(this_$iv, instance$iv);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DelicateCryptographyApi
    @NotNull
    public byte[] decryptBlocking(@NotNull byte[] iv, @NotNull byte[] ciphertextInput) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)ciphertextInput, (String)"ciphertextInput");
        Pooled<Cipher> this_$iv = this.cipher;
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$get(this_$iv);
        try {
            Cipher cipher = (Cipher)instance$iv;
            boolean bl = false;
            cipher.init(2, (Key)this.key, new IvParameterSpec(iv), this.state.getSecureRandom());
            byArray = cipher.doFinal(ciphertextInput);
        }
        finally {
            Pooled.access$put(this_$iv, instance$iv);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }
}

