/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.operations;

import dev.whyoleg.cryptography.operations.signature.SignatureVerifier;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/operations/JdkSignatureVerifier;", "Ldev/whyoleg/cryptography/operations/signature/SignatureVerifier;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "algorithm", "", "parameters", "Ljava/security/spec/AlgorithmParameterSpec;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PublicKey;Ljava/lang/String;Ljava/security/spec/AlgorithmParameterSpec;)V", "signature", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljava/security/Signature;", "Ldev/whyoleg/cryptography/providers/jdk/JSignature;", "verifySignatureBlocking", "", "dataInput", "", "signatureInput", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkSignatureVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkSignatureVerifier.kt\ndev/whyoleg/cryptography/providers/jdk/operations/JdkSignatureVerifier\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n39#2,3:28\n43#2:32\n1#3:31\n*S KotlinDebug\n*F\n+ 1 JdkSignatureVerifier.kt\ndev/whyoleg/cryptography/providers/jdk/operations/JdkSignatureVerifier\n*L\n20#1:28,3\n20#1:32\n*E\n"})
public final class JdkSignatureVerifier
implements SignatureVerifier {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PublicKey key;
    @Nullable
    private final AlgorithmParameterSpec parameters;
    @NotNull
    private final Pooled<Signature> signature;

    public JdkSignatureVerifier(@NotNull JdkCryptographyState state, @NotNull PublicKey key, @NotNull String algorithm, @Nullable AlgorithmParameterSpec parameters) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.state = state;
        this.key = key;
        this.parameters = parameters;
        this.signature = this.state.signature(algorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifySignatureBlocking(@NotNull byte[] dataInput, @NotNull byte[] signatureInput) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dataInput, (String)"dataInput");
        Intrinsics.checkNotNullParameter((Object)signatureInput, (String)"signatureInput");
        Pooled<Signature> this_$iv = this.signature;
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$get(this_$iv);
        try {
            Signature signature = (Signature)instance$iv;
            boolean bl2 = false;
            signature.initVerify(this.key);
            AlgorithmParameterSpec algorithmParameterSpec = this.parameters;
            if (algorithmParameterSpec != null) {
                AlgorithmParameterSpec p0 = algorithmParameterSpec;
                boolean bl3 = false;
                signature.setParameter(p0);
            }
            signature.update(dataInput);
            bl = signature.verify(signatureInput);
        }
        finally {
            Pooled.access$put(this_$iv, instance$iv);
        }
        return bl;
    }
}

