/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.operations;

import dev.whyoleg.cryptography.operations.signature.SignatureGenerator;
import dev.whyoleg.cryptography.operations.signature.SignatureVerifier;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.Pooled;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/operations/JdkMacSignature;", "Ldev/whyoleg/cryptography/operations/signature/SignatureGenerator;", "Ldev/whyoleg/cryptography/operations/signature/SignatureVerifier;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljavax/crypto/SecretKey;", "Ldev/whyoleg/cryptography/providers/jdk/JSecretKey;", "algorithm", "", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljavax/crypto/SecretKey;Ljava/lang/String;)V", "mac", "Ldev/whyoleg/cryptography/providers/jdk/Pooled;", "Ljavax/crypto/Mac;", "Ldev/whyoleg/cryptography/providers/jdk/JMac;", "generateSignatureBlocking", "", "dataInput", "verifySignatureBlocking", "", "signatureInput", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkMacSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkMacSignature.kt\ndev/whyoleg/cryptography/providers/jdk/operations/JdkMacSignature\n+ 2 pooling.kt\ndev/whyoleg/cryptography/providers/jdk/Pooled\n*L\n1#1,27:1\n39#2,5:28\n*S KotlinDebug\n*F\n+ 1 JdkMacSignature.kt\ndev/whyoleg/cryptography/providers/jdk/operations/JdkMacSignature\n*L\n18#1:28,5\n*E\n"})
public final class JdkMacSignature
implements SignatureGenerator,
SignatureVerifier {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final SecretKey key;
    @NotNull
    private final Pooled<Mac> mac;

    public JdkMacSignature(@NotNull JdkCryptographyState state, @NotNull SecretKey key, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.state = state;
        this.key = key;
        this.mac = this.state.mac(algorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] generateSignatureBlocking(@NotNull byte[] dataInput) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)dataInput, (String)"dataInput");
        Pooled<Mac> this_$iv = this.mac;
        boolean $i$f$use = false;
        Object instance$iv = Pooled.access$get(this_$iv);
        try {
            Mac mac = (Mac)instance$iv;
            boolean bl = false;
            mac.init(this.key);
            byArray = mac.doFinal(dataInput);
        }
        finally {
            Pooled.access$put(this_$iv, instance$iv);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    public boolean verifySignatureBlocking(@NotNull byte[] dataInput, @NotNull byte[] signatureInput) {
        Intrinsics.checkNotNullParameter((Object)dataInput, (String)"dataInput");
        Intrinsics.checkNotNullParameter((Object)signatureInput, (String)"signatureInput");
        return Arrays.equals(this.generateSignatureBlocking(dataInput), signatureInput);
    }
}

