/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.materials;

import dev.whyoleg.cryptography.materials.key.EncodableKey;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import dev.whyoleg.cryptography.providers.jdk.materials.PemKt;
import java.security.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rR\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey;", "KF", "Ldev/whyoleg/cryptography/materials/key/KeyFormat;", "Ldev/whyoleg/cryptography/materials/key/EncodableKey;", "key", "Ljava/security/Key;", "Ldev/whyoleg/cryptography/providers/jdk/JKey;", "pemAlgorithm", "", "(Ljava/security/Key;Ljava/lang/String;)V", "encodeToBlocking", "", "format", "(Ldev/whyoleg/cryptography/materials/key/KeyFormat;)[B", "cryptography-provider-jdk"})
@SourceDebugExtension(value={"SMAP\nJdkEncodableKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkEncodableKey.kt\ndev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public class JdkEncodableKey<KF extends KeyFormat>
implements EncodableKey<KF> {
    @NotNull
    private final Key key;
    @NotNull
    private final String pemAlgorithm;

    public JdkEncodableKey(@NotNull Key key, @NotNull String pemAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)pemAlgorithm, (String)"pemAlgorithm");
        this.key = key;
        this.pemAlgorithm = pemAlgorithm;
    }

    public /* synthetic */ JdkEncodableKey(Key key, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string2 = key.getAlgorithm();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAlgorithm(...)");
            string = string2;
        }
        this(key, string);
    }

    @NotNull
    public byte[] encodeToBlocking(@NotNull KF format) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(format, (String)"format");
        switch (format.getName()) {
            case "RAW": {
                if (!Intrinsics.areEqual((Object)this.key.getFormat(), (Object)"RAW")) {
                    boolean $i$a$-check-JdkEncodableKey$encodeToBlocking$32 = false;
                    String $i$a$-check-JdkEncodableKey$encodeToBlocking$32 = "Wrong JDK Key format, expected `RAW` got `" + this.key.getFormat() + '`';
                    throw new IllegalStateException($i$a$-check-JdkEncodableKey$encodeToBlocking$32.toString());
                }
                byte[] byArray2 = this.key.getEncoded();
                Intrinsics.checkNotNull((Object)byArray2);
                byArray = byArray2;
                break;
            }
            case "DER": {
                if (!(Intrinsics.areEqual((Object)this.key.getFormat(), (Object)"PKCS#8") || Intrinsics.areEqual((Object)this.key.getFormat(), (Object)"X.509"))) {
                    boolean bl = false;
                    String string = "Wrong JDK Key format, expected `PKCS#8` or `X.509 got `" + this.key.getFormat() + '`';
                    throw new IllegalStateException(string.toString());
                }
                byte[] byArray3 = this.key.getEncoded();
                Intrinsics.checkNotNull((Object)byArray3);
                byArray = byArray3;
                break;
            }
            case "PEM": {
                String string;
                String string2 = this.key.getFormat();
                if (Intrinsics.areEqual((Object)string2, (Object)"PKCS#8")) {
                    string = "PRIVATE KEY";
                } else if (Intrinsics.areEqual((Object)string2, (Object)"X.509")) {
                    string = "PUBLIC KEY";
                } else {
                    throw new IllegalStateException(("Wrong JDK Key format, expected `PKCS#8` or `X.509 got `" + this.key.getFormat() + '`').toString());
                }
                String type = string;
                byte[] byArray4 = this.key.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getEncoded(...)");
                byArray = PemKt.encodeToPem(byArray4, type);
                break;
            }
            default: {
                throw new IllegalStateException((format + " is not supported").toString());
            }
        }
        return byArray;
    }
}

