/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.asymmetric.RSA;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.algorithms.RsaPssKeyPair;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkKeyPairGenerator;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.RSAKeyGenParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002*\u00060\u000bj\u0002`\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e*\u00060\u000fj\u0002`\u0010H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPssKeyPairGenerator;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkKeyPairGenerator;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PSS$KeyPair;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "keyGenParameters", "Ljava/security/spec/RSAKeyGenParameterSpec;", "hashAlgorithmName", "", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/spec/RSAKeyGenParameterSpec;Ljava/lang/String;)V", "convert", "Ljava/security/KeyPair;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPair;", "init", "", "Ljava/security/KeyPairGenerator;", "Ldev/whyoleg/cryptography/providers/jdk/JKeyPairGenerator;", "cryptography-provider-jdk"})
final class RsaPssKeyPairGenerator
extends JdkKeyPairGenerator<RSA.PSS.KeyPair> {
    @NotNull
    private final RSAKeyGenParameterSpec keyGenParameters;
    @NotNull
    private final String hashAlgorithmName;

    public RsaPssKeyPairGenerator(@NotNull JdkCryptographyState state, @NotNull RSAKeyGenParameterSpec keyGenParameters, @NotNull String hashAlgorithmName) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)keyGenParameters, (String)"keyGenParameters");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithmName, (String)"hashAlgorithmName");
        super(state, "RSA");
        this.keyGenParameters = keyGenParameters;
        this.hashAlgorithmName = hashAlgorithmName;
    }

    @Override
    protected void init(@NotNull KeyPairGenerator $this$init) {
        Intrinsics.checkNotNullParameter((Object)$this$init, (String)"<this>");
        $this$init.initialize(this.keyGenParameters, this.getState().getSecureRandom());
    }

    @Override
    @NotNull
    protected RSA.PSS.KeyPair convert(@NotNull KeyPair $this$convert) {
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        return new RsaPssKeyPair(this.getState(), $this$convert, this.hashAlgorithmName);
    }
}

