/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.algorithms.asymmetric.RSA;
import dev.whyoleg.cryptography.operations.signature.SignatureGenerator;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkEncodableKey;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkSignatureGenerator;
import java.security.PrivateKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/RsaPkcs1PrivateKey;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PKCS1$PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/RSA$PrivateKey$Format;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "hashAlgorithmName", "", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PrivateKey;Ljava/lang/String;)V", "signatureGenerator", "Ldev/whyoleg/cryptography/operations/signature/SignatureGenerator;", "cryptography-provider-jdk"})
final class RsaPkcs1PrivateKey
extends JdkEncodableKey<RSA.PrivateKey.Format>
implements RSA.PKCS1.PrivateKey {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PrivateKey key;
    @NotNull
    private final String hashAlgorithmName;

    public RsaPkcs1PrivateKey(@NotNull JdkCryptographyState state, @NotNull PrivateKey key, @NotNull String hashAlgorithmName) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)hashAlgorithmName, (String)"hashAlgorithmName");
        super(key, "RSA");
        this.state = state;
        this.key = key;
        this.hashAlgorithmName = hashAlgorithmName;
    }

    @NotNull
    public SignatureGenerator signatureGenerator() {
        return new JdkSignatureGenerator(this.state, this.key, this.hashAlgorithmName + "withRSA", null);
    }
}

