/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.algorithms.asymmetric.EC;
import dev.whyoleg.cryptography.algorithms.asymmetric.ECDSA;
import dev.whyoleg.cryptography.algorithms.digest.Digest;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import dev.whyoleg.cryptography.operations.signature.SignatureVerifier;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyStateKt;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkEcdsaKt;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkEncodableKey;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkSignatureVerifier;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\f\u001a\u00020\u0012H\u0016R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/EcdsaPublicKey;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/ECDSA$PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PublicKey$Format;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PublicKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPublicKey;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PublicKey;)V", "encodeToBlocking", "", "format", "signatureVerifier", "Ldev/whyoleg/cryptography/operations/signature/SignatureVerifier;", "digest", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "Ldev/whyoleg/cryptography/algorithms/digest/Digest;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/ECDSA$SignatureFormat;", "cryptography-provider-jdk"})
final class EcdsaPublicKey
extends JdkEncodableKey<EC.PublicKey.Format>
implements ECDSA.PublicKey {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PublicKey key;

    public EcdsaPublicKey(@NotNull JdkCryptographyState state, @NotNull PublicKey key) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(key, "EC");
        this.state = state;
        this.key = key;
    }

    @NotNull
    public SignatureVerifier signatureVerifier(@NotNull CryptographyAlgorithmId<Digest> digest, @NotNull ECDSA.SignatureFormat format) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new JdkSignatureVerifier(this.state, this.key, JdkCryptographyStateKt.hashAlgorithmName(digest) + "withECDSA" + JdkEcdsaKt.access$algorithmSuffix(format), null);
    }

    @Override
    @NotNull
    public byte[] encodeToBlocking(@NotNull EC.PublicKey.Format format) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        if (WhenMappings.$EnumSwitchMapping$0[format.ordinal()] == 1) {
            PublicKey publicKey = this.key;
            Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
            ECPublicKey cfr_ignored_0 = (ECPublicKey)publicKey;
            ECPoint point = ((ECPublicKey)this.key).getW();
            int fieldSize = (((ECPublicKey)this.key).getParams().getCurve().getField().getFieldSize() + 7) / 8;
            byte[] output = new byte[fieldSize * 2 + 1];
            output[0] = 4;
            byte[] byArray2 = point.getAffineX().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            byte[] x = JdkEcdsaKt.access$trimLeadingZeros(byArray2);
            byte[] byArray3 = point.getAffineY().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
            byte[] y = JdkEcdsaKt.access$trimLeadingZeros(byArray3);
            if (!(x.length <= fieldSize && y.length <= fieldSize)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            ArraysKt.copyInto$default((byte[])x, (byte[])output, (int)(fieldSize - x.length + 1), (int)0, (int)0, (int)12, null);
            ArraysKt.copyInto$default((byte[])y, (byte[])output, (int)(fieldSize * 2 - y.length + 1), (int)0, (int)0, (int)12, null);
            byArray = output;
        } else {
            byArray = super.encodeToBlocking((KeyFormat)format);
        }
        return byArray;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EC.PublicKey.Format.values().length];
            try {
                nArray[EC.PublicKey.Format.RAW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

