/*
 * Decompiled with CFR 0.152.
 */
package dev.whyoleg.cryptography.providers.jdk.algorithms;

import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.algorithms.asymmetric.EC;
import dev.whyoleg.cryptography.algorithms.asymmetric.ECDSA;
import dev.whyoleg.cryptography.algorithms.digest.Digest;
import dev.whyoleg.cryptography.operations.signature.SignatureGenerator;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyState;
import dev.whyoleg.cryptography.providers.jdk.JdkCryptographyStateKt;
import dev.whyoleg.cryptography.providers.jdk.algorithms.JdkEcdsaKt;
import dev.whyoleg.cryptography.providers.jdk.materials.JdkEncodableKey;
import dev.whyoleg.cryptography.providers.jdk.operations.JdkSignatureGenerator;
import java.security.PrivateKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/whyoleg/cryptography/providers/jdk/algorithms/EcdsaPrivateKey;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/ECDSA$PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/materials/JdkEncodableKey;", "Ldev/whyoleg/cryptography/algorithms/asymmetric/EC$PrivateKey$Format;", "state", "Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;", "key", "Ljava/security/PrivateKey;", "Ldev/whyoleg/cryptography/providers/jdk/JPrivateKey;", "(Ldev/whyoleg/cryptography/providers/jdk/JdkCryptographyState;Ljava/security/PrivateKey;)V", "signatureGenerator", "Ldev/whyoleg/cryptography/operations/signature/SignatureGenerator;", "digest", "Ldev/whyoleg/cryptography/CryptographyAlgorithmId;", "Ldev/whyoleg/cryptography/algorithms/digest/Digest;", "format", "Ldev/whyoleg/cryptography/algorithms/asymmetric/ECDSA$SignatureFormat;", "cryptography-provider-jdk"})
final class EcdsaPrivateKey
extends JdkEncodableKey<EC.PrivateKey.Format>
implements ECDSA.PrivateKey {
    @NotNull
    private final JdkCryptographyState state;
    @NotNull
    private final PrivateKey key;

    public EcdsaPrivateKey(@NotNull JdkCryptographyState state, @NotNull PrivateKey key) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        super(key, "EC");
        this.state = state;
        this.key = key;
    }

    @NotNull
    public SignatureGenerator signatureGenerator(@NotNull CryptographyAlgorithmId<Digest> digest, @NotNull ECDSA.SignatureFormat format) {
        Intrinsics.checkNotNullParameter(digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new JdkSignatureGenerator(this.state, this.key, JdkCryptographyStateKt.hashAlgorithmName(digest) + "withECDSA" + JdkEcdsaKt.access$algorithmSuffix(format), null);
    }
}

