/*
 * Decompiled with CFR 0.152.
 */
package dev.warrant;

import dev.warrant.ListParams;
import dev.warrant.ObjectFilters;
import dev.warrant.RequestOptions;
import dev.warrant.WarrantBaseClient;
import dev.warrant.WarrantConfig;
import dev.warrant.exception.WarrantException;
import dev.warrant.model.QueryResultSet;
import dev.warrant.model.Warrant;
import dev.warrant.model.WarrantSubject;
import dev.warrant.model.object.BaseWarrantObjectListResult;
import dev.warrant.model.object.Feature;
import dev.warrant.model.object.ListResult;
import dev.warrant.model.object.Permission;
import dev.warrant.model.object.PricingTier;
import dev.warrant.model.object.Role;
import dev.warrant.model.object.Tenant;
import dev.warrant.model.object.User;
import dev.warrant.model.object.WarrantObject;
import java.net.http.HttpClient;
import java.util.Arrays;

public class WarrantClient
extends WarrantBaseClient {
    WarrantClient(WarrantConfig config, HttpClient client) {
        super(config, client);
    }

    public WarrantClient(WarrantConfig config) {
        super(config);
    }

    public User createUser() throws WarrantException {
        return this.createUser(new RequestOptions());
    }

    public User createUser(RequestOptions requestOptions) throws WarrantException {
        return this.createObject("user", User.class, requestOptions);
    }

    public User createUser(User user) throws WarrantException {
        return this.createUser(user, new RequestOptions());
    }

    public User createUser(User user, RequestOptions requestOptions) throws WarrantException {
        return this.createObject("user", user.getUserId(), user.getMeta(), User.class, requestOptions);
    }

    public User[] createUsers(User[] users) throws WarrantException {
        return this.createUsers(users, new RequestOptions());
    }

    public User[] createUsers(User[] users, RequestOptions requestOptions) throws WarrantException {
        return (User[])this.createObjects(users, User[].class, requestOptions);
    }

    public User updateUser(String userId, User toUpdate) throws WarrantException {
        return this.updateUser(userId, toUpdate, new RequestOptions());
    }

    public User updateUser(String userId, User toUpdate, RequestOptions requestOptions) throws WarrantException {
        return this.updateObject("user", userId, toUpdate.getMeta(), User.class, requestOptions);
    }

    public String deleteUser(User user) throws WarrantException {
        return this.deleteUser(user.getUserId(), new RequestOptions());
    }

    public String deleteUser(String userId) throws WarrantException {
        return this.deleteUser(userId, new RequestOptions());
    }

    public String deleteUser(String userId, RequestOptions requestOptions) throws WarrantException {
        return this.deleteObject("user", userId, requestOptions);
    }

    public String deleteUsers(User[] users) throws WarrantException {
        return this.deleteObjects(users);
    }

    public String deleteUsers(User[] users, RequestOptions requestOptions) throws WarrantException {
        return this.deleteObjects(users, requestOptions);
    }

    public User getUser(String userId) throws WarrantException {
        return this.getUser(userId, new RequestOptions());
    }

    public User getUser(String userId, RequestOptions requestOptions) throws WarrantException {
        return this.getObject("user", userId, User.class, requestOptions);
    }

    public ListResult<User> listUsers(int limit) throws WarrantException {
        return this.listUsers(new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<User> listUsers(int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listUsers(new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<User> listUsers(ListParams listParams) throws WarrantException {
        return this.listUsers(listParams, new RequestOptions());
    }

    public ListResult<User> listUsers(ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        BaseWarrantObjectListResult userObjects = this.listObjects(new ObjectFilters().withObjectType("user"), new ListParams().withLimit(10), requestOptions);
        User[] users = (User[])Arrays.stream(userObjects.getResults()).map(result -> new User(result.getObjectId(), result.getMeta())).toArray(User[]::new);
        return new ListResult<User>(users, userObjects.getPrevCursor(), userObjects.getNextCursor());
    }

    public ListResult<User> listUsersForTenant(Tenant tenant, int limit) throws WarrantException {
        return this.listUsersForTenant(tenant.getTenantId(), new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<User> listUsersForTenant(Tenant tenant, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listUsersForTenant(tenant.getTenantId(), new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<User> listUsersForTenant(Tenant tenant, ListParams listParams) throws WarrantException {
        return this.listUsersForTenant(tenant.getTenantId(), listParams, new RequestOptions());
    }

    public ListResult<User> listUsersForTenant(Tenant tenant, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        return this.listUsersForTenant(tenant.getTenantId(), listParams, requestOptions);
    }

    public ListResult<User> listUsersForTenant(String tenantId, int limit) throws WarrantException {
        return this.listUsersForTenant(tenantId, new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<User> listUsersForTenant(String tenantId, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listUsersForTenant(tenantId, new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<User> listUsersForTenant(String tenantId, ListParams listParams) throws WarrantException {
        return this.listUsersForTenant(tenantId, listParams, new RequestOptions());
    }

    public ListResult<User> listUsersForTenant(String tenantId, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        QueryResultSet queryResultSet = this.query("select * of type user for tenant:" + tenantId, listParams, requestOptions);
        User[] users = (User[])Arrays.stream(queryResultSet.getResults()).map(result -> new User(result.getObjectId(), result.getMeta())).toArray(User[]::new);
        return new ListResult<User>(users, queryResultSet.getPrevCursor(), queryResultSet.getNextCursor());
    }

    public Tenant createTenant() throws WarrantException {
        return this.createTenant(new Tenant(), new RequestOptions());
    }

    public Tenant createTenant(RequestOptions requestOptions) throws WarrantException {
        return this.createTenant(new Tenant(), requestOptions);
    }

    public Tenant createTenant(Tenant tenant) throws WarrantException {
        return this.createTenant(tenant, new RequestOptions());
    }

    public Tenant createTenant(Tenant tenant, RequestOptions requestOptions) throws WarrantException {
        return this.createObject("tenant", tenant.getTenantId(), tenant.getMeta(), Tenant.class, requestOptions);
    }

    public Tenant[] createTenants(Tenant[] tenants) throws WarrantException {
        return this.createTenants(tenants, new RequestOptions());
    }

    public Tenant[] createTenants(Tenant[] tenants, RequestOptions requestOptions) throws WarrantException {
        return (Tenant[])this.createObjects(tenants, Tenant[].class, requestOptions);
    }

    public Tenant updateTenant(String tenantId, Tenant toUpdate) throws WarrantException {
        return this.updateTenant(tenantId, toUpdate, new RequestOptions());
    }

    public Tenant updateTenant(String tenantId, Tenant toUpdate, RequestOptions requestOptions) throws WarrantException {
        return this.updateObject("tenant", tenantId, toUpdate.getMeta(), Tenant.class, requestOptions);
    }

    public String deleteTenant(Tenant tenant) throws WarrantException {
        return this.deleteTenant(tenant.getTenantId(), new RequestOptions());
    }

    public String deleteTenant(Tenant tenant, RequestOptions requestOptions) throws WarrantException {
        return this.deleteTenant(tenant.getTenantId(), requestOptions);
    }

    public String deleteTenant(String tenantId) throws WarrantException {
        return this.deleteTenant(tenantId, new RequestOptions());
    }

    public String deleteTenant(String tenantId, RequestOptions requestOptions) throws WarrantException {
        return this.deleteObject("tenant", tenantId, requestOptions);
    }

    public String deleteTenants(Tenant[] tenants) throws WarrantException {
        return this.deleteTenants(tenants, new RequestOptions());
    }

    public String deleteTenants(Tenant[] tenants, RequestOptions requestOptions) throws WarrantException {
        return this.deleteObjects(tenants, requestOptions);
    }

    public Tenant getTenant(String tenantId) throws WarrantException {
        return this.getTenant(tenantId, new RequestOptions());
    }

    public Tenant getTenant(String tenantId, RequestOptions requestOptions) throws WarrantException {
        return this.getObject("tenant", tenantId, Tenant.class, requestOptions);
    }

    public ListResult<Tenant> listTenants(int limit) throws WarrantException {
        return this.listTenants(new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Tenant> listTenants(int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listTenants(new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Tenant> listTenants(ListParams listParams) throws WarrantException {
        return this.listTenants(listParams, new RequestOptions());
    }

    public ListResult<Tenant> listTenants(ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        BaseWarrantObjectListResult tenantObjects = this.listObjects(new ObjectFilters().withObjectType("tenant"), new ListParams().withLimit(10), requestOptions);
        Tenant[] tenants = (Tenant[])Arrays.stream(tenantObjects.getResults()).map(result -> new Tenant(result.getObjectId(), result.getMeta())).toArray(Tenant[]::new);
        return new ListResult<Tenant>(tenants, tenantObjects.getPrevCursor(), tenantObjects.getNextCursor());
    }

    public ListResult<Tenant> listTenantsForUser(User user, int limit) throws WarrantException {
        return this.listTenantsForUser(user.getUserId(), new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Tenant> listTenantsForUser(User user, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listTenantsForUser(user.getUserId(), new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Tenant> listTenantsForUser(User user, ListParams listParams) throws WarrantException {
        return this.listTenantsForUser(user.getUserId(), listParams, new RequestOptions());
    }

    public ListResult<Tenant> listTenantsForUser(User user, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        return this.listTenantsForUser(user.getUserId(), listParams, requestOptions);
    }

    public ListResult<Tenant> listTenantsForUser(String userId, int limit) throws WarrantException {
        return this.listTenantsForUser(userId, new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Tenant> listTenantsForUser(String userId, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listTenantsForUser(userId, new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Tenant> listTenantsForUser(String userId, ListParams listParams) throws WarrantException {
        return this.listTenantsForUser(userId, listParams, new RequestOptions());
    }

    public ListResult<Tenant> listTenantsForUser(String userId, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        QueryResultSet queryResultSet = this.query("select tenant where user:" + userId + " is *", listParams, requestOptions);
        Tenant[] tenants = (Tenant[])Arrays.stream(queryResultSet.getResults()).map(result -> new Tenant(result.getObjectId(), result.getMeta())).toArray(Tenant[]::new);
        return new ListResult<Tenant>(tenants, queryResultSet.getPrevCursor(), queryResultSet.getNextCursor());
    }

    public Role createRole() throws WarrantException {
        return this.createRole(new RequestOptions());
    }

    public Role createRole(RequestOptions requestOptions) throws WarrantException {
        return this.createObject("role", Role.class, requestOptions);
    }

    public Role createRole(Role role) throws WarrantException {
        return this.createRole(role, new RequestOptions());
    }

    public Role createRole(Role role, RequestOptions requestOptions) throws WarrantException {
        return this.createObject("role", role.getRoleId(), role.getMeta(), Role.class, requestOptions);
    }

    public Role updateRole(String roleId, Role toUpdate) throws WarrantException {
        return this.updateRole(roleId, toUpdate, new RequestOptions());
    }

    public Role updateRole(String roleId, Role toUpdate, RequestOptions requestOptions) throws WarrantException {
        return this.updateObject("role", roleId, toUpdate.getMeta(), Role.class, requestOptions);
    }

    public String deleteRole(Role role) throws WarrantException {
        return this.deleteRole(role.getRoleId(), new RequestOptions());
    }

    public String deleteRole(Role role, RequestOptions requestOptions) throws WarrantException {
        return this.deleteRole(role.getRoleId(), requestOptions);
    }

    public String deleteRole(String roleId) throws WarrantException {
        return this.deleteRole(roleId, new RequestOptions());
    }

    public String deleteRole(String roleId, RequestOptions requestOptions) throws WarrantException {
        return this.deleteObject("role", roleId, requestOptions);
    }

    public Role getRole(String roleId) throws WarrantException {
        return this.getRole(roleId, new RequestOptions());
    }

    public Role getRole(String roleId, RequestOptions requestOptions) throws WarrantException {
        return this.getObject("role", roleId, Role.class, requestOptions);
    }

    public ListResult<Role> listRoles(int limit) throws WarrantException {
        return this.listRoles(new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Role> listRoles(int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listRoles(new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Role> listRoles(ListParams listParams) throws WarrantException {
        return this.listRoles(listParams, new RequestOptions());
    }

    public ListResult<Role> listRoles(ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        BaseWarrantObjectListResult roleObjects = this.listObjects(new ObjectFilters().withObjectType("role"), new ListParams().withLimit(10), requestOptions);
        Role[] roles = (Role[])Arrays.stream(roleObjects.getResults()).map(result -> new Role(result.getObjectId(), result.getMeta())).toArray(Role[]::new);
        return new ListResult<Role>(roles, roleObjects.getPrevCursor(), roleObjects.getNextCursor());
    }

    public ListResult<Role> listRolesForUser(User user, int limit) throws WarrantException {
        return this.listRolesForUser(user.getUserId(), new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Role> listRolesForUser(User user, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listRolesForUser(user.getUserId(), new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Role> listRolesForUser(User user, ListParams listParams) throws WarrantException {
        return this.listRolesForUser(user.getUserId(), listParams, new RequestOptions());
    }

    public ListResult<Role> listRolesForUser(User user, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        return this.listRolesForUser(user.getUserId(), listParams, requestOptions);
    }

    public ListResult<Role> listRolesForUser(String userId, int limit) throws WarrantException {
        return this.listRolesForUser(userId, new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Role> listRolesForUser(String userId, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listRolesForUser(userId, new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Role> listRolesForUser(String userId, ListParams listParams) throws WarrantException {
        return this.listRolesForUser(userId, listParams, new RequestOptions());
    }

    public ListResult<Role> listRolesForUser(String userId, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        QueryResultSet queryResultSet = this.query("select role where user:" + userId + " is *", listParams, requestOptions);
        Role[] roles = (Role[])Arrays.stream(queryResultSet.getResults()).map(result -> new Role(result.getObjectId(), result.getMeta())).toArray(Role[]::new);
        return new ListResult<Role>(roles, queryResultSet.getPrevCursor(), queryResultSet.getNextCursor());
    }

    public Permission createPermission() throws WarrantException {
        return this.createPermission(new RequestOptions());
    }

    public Permission createPermission(RequestOptions requestOptions) throws WarrantException {
        return this.createObject("permission", Permission.class, requestOptions);
    }

    public Permission createPermission(Permission permission) throws WarrantException {
        return this.createPermission(permission, new RequestOptions());
    }

    public Permission createPermission(Permission permission, RequestOptions requestOptions) throws WarrantException {
        return this.createObject("permission", permission.getPermissionId(), permission.getMeta(), Permission.class, requestOptions);
    }

    public Permission updatePermission(String permissionId, Permission toUpdate) throws WarrantException {
        return this.updatePermission(permissionId, toUpdate, new RequestOptions());
    }

    public Permission updatePermission(String permissionId, Permission toUpdate, RequestOptions requestOptions) throws WarrantException {
        return this.updateObject("permission", permissionId, toUpdate.getMeta(), Permission.class, requestOptions);
    }

    public String deletePermission(Permission permission) throws WarrantException {
        return this.deletePermission(permission.getPermissionId(), new RequestOptions());
    }

    public String deletePermission(Permission permission, RequestOptions requestOptions) throws WarrantException {
        return this.deletePermission(permission.getPermissionId(), requestOptions);
    }

    public String deletePermission(String permissionId) throws WarrantException {
        return this.deletePermission(permissionId, new RequestOptions());
    }

    public String deletePermission(String permissionId, RequestOptions requestOptions) throws WarrantException {
        return this.deleteObject("permission", permissionId, requestOptions);
    }

    public Permission getPermission(String permissionId) throws WarrantException {
        return this.getPermission(permissionId, new RequestOptions());
    }

    public Permission getPermission(String permissionId, RequestOptions requestOptions) throws WarrantException {
        return this.getObject("permission", permissionId, Permission.class, requestOptions);
    }

    public ListResult<Permission> listPermissions(int limit) throws WarrantException {
        return this.listPermissions(new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Permission> listPermissions(int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listPermissions(new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Permission> listPermissions(ListParams listParams) throws WarrantException {
        return this.listPermissions(listParams, new RequestOptions());
    }

    public ListResult<Permission> listPermissions(ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        BaseWarrantObjectListResult permissionObjects = this.listObjects(new ObjectFilters().withObjectType("permission"), new ListParams().withLimit(10), requestOptions);
        Permission[] permissions = (Permission[])Arrays.stream(permissionObjects.getResults()).map(result -> new Permission(result.getObjectId(), result.getMeta())).toArray(Permission[]::new);
        return new ListResult<Permission>(permissions, permissionObjects.getPrevCursor(), permissionObjects.getNextCursor());
    }

    public ListResult<Permission> listPermissionsForUser(User user, int limit) throws WarrantException {
        return this.listPermissionsForUser(user.getUserId(), new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Permission> listPermissionsForUser(User user, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listPermissionsForUser(user.getUserId(), new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Permission> listPermissionsForUser(User user, ListParams listParams) throws WarrantException {
        return this.listPermissionsForUser(user.getUserId(), listParams, new RequestOptions());
    }

    public ListResult<Permission> listPermissionsForUser(User user, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        return this.listPermissionsForUser(user.getUserId(), listParams, requestOptions);
    }

    public ListResult<Permission> listPermissionsForUser(String userId, int limit) throws WarrantException {
        return this.listPermissionsForUser(userId, new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Permission> listPermissionsForUser(String userId, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listPermissionsForUser(userId, new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Permission> listPermissionsForUser(String userId, ListParams listParams) throws WarrantException {
        return this.listPermissionsForUser(userId, listParams, new RequestOptions());
    }

    public ListResult<Permission> listPermissionsForUser(String userId, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        QueryResultSet queryResultSet = this.query("select permission where user:" + userId + " is *", listParams, requestOptions);
        Permission[] permissions = (Permission[])Arrays.stream(queryResultSet.getResults()).map(result -> new Permission(result.getObjectId(), result.getMeta())).toArray(Permission[]::new);
        return new ListResult<Permission>(permissions, queryResultSet.getPrevCursor(), queryResultSet.getNextCursor());
    }

    public ListResult<Permission> listPermissionsForRole(Role role, int limit) throws WarrantException {
        return this.listPermissionsForRole(role.getRoleId(), new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Permission> listPermissionsForRole(Role role, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listPermissionsForRole(role.getRoleId(), new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Permission> listPermissionsForRole(Role role, ListParams listParams) throws WarrantException {
        return this.listPermissionsForRole(role.getRoleId(), listParams, new RequestOptions());
    }

    public ListResult<Permission> listPermissionsForRole(Role role, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        return this.listPermissionsForRole(role.getRoleId(), listParams, requestOptions);
    }

    public ListResult<Permission> listPermissionsForRole(String roleId, int limit) throws WarrantException {
        return this.listPermissionsForRole(roleId, new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Permission> listPermissionsForRole(String roleId, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listPermissionsForRole(roleId, new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Permission> listPermissionsForRole(String roleId, ListParams listParams) throws WarrantException {
        return this.listPermissionsForRole(roleId, listParams, new RequestOptions());
    }

    public ListResult<Permission> listPermissionsForRole(String roleId, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        QueryResultSet queryResultSet = this.query("select permission where role:" + roleId + " is *", listParams, requestOptions);
        Permission[] permissions = (Permission[])Arrays.stream(queryResultSet.getResults()).map(result -> new Permission(result.getObjectId(), result.getMeta())).toArray(Permission[]::new);
        return new ListResult<Permission>(permissions, queryResultSet.getPrevCursor(), queryResultSet.getNextCursor());
    }

    public Feature createFeature() throws WarrantException {
        return this.createFeature(new RequestOptions());
    }

    public Feature createFeature(RequestOptions requestOptions) throws WarrantException {
        return this.createObject("feature", Feature.class, requestOptions);
    }

    public Feature createFeature(Feature feature) throws WarrantException {
        return this.createFeature(feature, new RequestOptions());
    }

    public Feature createFeature(Feature feature, RequestOptions requestOptions) throws WarrantException {
        return this.createObject("feature", feature.getFeatureId(), feature.getMeta(), Feature.class, requestOptions);
    }

    public String deleteFeature(Feature feature) throws WarrantException {
        return this.deleteFeature(feature.getFeatureId(), new RequestOptions());
    }

    public String deleteFeature(Feature feature, RequestOptions requestOptions) throws WarrantException {
        return this.deleteFeature(feature.getFeatureId(), requestOptions);
    }

    public String deleteFeature(String featureId) throws WarrantException {
        return this.deleteFeature(featureId, new RequestOptions());
    }

    public String deleteFeature(String featureId, RequestOptions requestOptions) throws WarrantException {
        return this.deleteObject("feature", featureId, requestOptions);
    }

    public Feature getFeature(String featureId) throws WarrantException {
        return this.getFeature(featureId, new RequestOptions());
    }

    public Feature getFeature(String featureId, RequestOptions requestOptions) throws WarrantException {
        return this.getObject("feature", featureId, Feature.class, requestOptions);
    }

    public ListResult<Feature> listFeatures(int limit) throws WarrantException {
        return this.listFeatures(new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Feature> listFeatures(int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listFeatures(new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Feature> listFeatures(ListParams listParams) throws WarrantException {
        return this.listFeatures(listParams, new RequestOptions());
    }

    public ListResult<Feature> listFeatures(ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        BaseWarrantObjectListResult featureObjects = this.listObjects(new ObjectFilters().withObjectType("feature"), new ListParams().withLimit(10), requestOptions);
        Feature[] features = (Feature[])Arrays.stream(featureObjects.getResults()).map(result -> new Feature(result.getObjectId(), result.getMeta())).toArray(Feature[]::new);
        return new ListResult<Feature>(features, featureObjects.getPrevCursor(), featureObjects.getNextCursor());
    }

    public ListResult<Feature> listFeaturesForUser(User user, int limit) throws WarrantException {
        return this.listFeaturesForUser(user.getUserId(), new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForUser(User user, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listFeaturesForUser(user.getUserId(), new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Feature> listFeaturesForUser(User user, ListParams listParams) throws WarrantException {
        return this.listFeaturesForUser(user.getUserId(), listParams, new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForUser(User user, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        return this.listFeaturesForUser(user.getUserId(), listParams, requestOptions);
    }

    public ListResult<Feature> listFeaturesForUser(String userId, int limit) throws WarrantException {
        return this.listFeaturesForUser(userId, new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForUser(String userId, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listFeaturesForUser(userId, new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Feature> listFeaturesForUser(String userId, ListParams listParams) throws WarrantException {
        return this.listFeaturesForUser(userId, listParams, new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForUser(String userId, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        QueryResultSet queryResultSet = this.query("select feature where user:" + userId + " is *", listParams, requestOptions);
        Feature[] features = (Feature[])Arrays.stream(queryResultSet.getResults()).map(result -> new Feature(result.getObjectId(), result.getMeta())).toArray(Feature[]::new);
        return new ListResult<Feature>(features, queryResultSet.getPrevCursor(), queryResultSet.getNextCursor());
    }

    public ListResult<Feature> listFeaturesForTenant(Tenant tenant, int limit) throws WarrantException {
        return this.listFeaturesForTenant(tenant.getTenantId(), new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForTenant(Tenant tenant, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listFeaturesForTenant(tenant.getTenantId(), new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Feature> listFeaturesForTenant(Tenant tenant, ListParams listParams) throws WarrantException {
        return this.listFeaturesForTenant(tenant.getTenantId(), listParams, new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForTenant(Tenant tenant, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        return this.listFeaturesForTenant(tenant.getTenantId(), listParams, requestOptions);
    }

    public ListResult<Feature> listFeaturesForTenant(String tenantId, int limit) throws WarrantException {
        return this.listFeaturesForTenant(tenantId, new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForTenant(String tenantId, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listFeaturesForTenant(tenantId, new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Feature> listFeaturesForTenant(String tenantId, ListParams listParams) throws WarrantException {
        return this.listFeaturesForTenant(tenantId, listParams, new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForTenant(String tenantId, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        QueryResultSet queryResultSet = this.query("select feature where tenant:" + tenantId + " is *", listParams, requestOptions);
        Feature[] features = (Feature[])Arrays.stream(queryResultSet.getResults()).map(result -> new Feature(result.getObjectId(), result.getMeta())).toArray(Feature[]::new);
        return new ListResult<Feature>(features, queryResultSet.getPrevCursor(), queryResultSet.getNextCursor());
    }

    public ListResult<Feature> listFeaturesForPricingTier(PricingTier pricingTier, int limit) throws WarrantException {
        return this.listFeaturesForPricingTier(pricingTier.getPricingTierId(), new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForPricingTier(PricingTier pricingTier, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listFeaturesForPricingTier(pricingTier.getPricingTierId(), new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Feature> listFeaturesForPricingTier(PricingTier pricingTier, ListParams listParams) throws WarrantException {
        return this.listFeaturesForPricingTier(pricingTier.getPricingTierId(), listParams, new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForPricingTier(PricingTier pricingTier, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        return this.listFeaturesForPricingTier(pricingTier.getPricingTierId(), listParams, requestOptions);
    }

    public ListResult<Feature> listFeaturesForPricingTier(String pricingTierId, int limit) throws WarrantException {
        return this.listFeaturesForPricingTier(pricingTierId, new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForPricingTier(String pricingTierId, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listFeaturesForPricingTier(pricingTierId, new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<Feature> listFeaturesForPricingTier(String pricingTierId, ListParams listParams) throws WarrantException {
        return this.listFeaturesForPricingTier(pricingTierId, listParams, new RequestOptions());
    }

    public ListResult<Feature> listFeaturesForPricingTier(String pricingTierId, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        QueryResultSet queryResultSet = this.query("select feature where pricing-tier:" + pricingTierId + " is *", listParams, requestOptions);
        Feature[] features = (Feature[])Arrays.stream(queryResultSet.getResults()).map(result -> new Feature(result.getObjectId(), result.getMeta())).toArray(Feature[]::new);
        return new ListResult<Feature>(features, queryResultSet.getPrevCursor(), queryResultSet.getNextCursor());
    }

    public PricingTier createPricingTier() throws WarrantException {
        return this.createPricingTier(new RequestOptions());
    }

    public PricingTier createPricingTier(RequestOptions requestOptions) throws WarrantException {
        return this.createObject("pricing-tier", PricingTier.class, requestOptions);
    }

    public PricingTier createPricingTier(PricingTier pricingTier) throws WarrantException {
        return this.createPricingTier(pricingTier, new RequestOptions());
    }

    public PricingTier createPricingTier(PricingTier pricingTier, RequestOptions requestOptions) throws WarrantException {
        return this.createObject("pricing-tier", pricingTier.getPricingTierId(), pricingTier.getMeta(), PricingTier.class, requestOptions);
    }

    public String deletePricingTier(PricingTier pricingTier) throws WarrantException {
        return this.deletePricingTier(pricingTier.getPricingTierId(), new RequestOptions());
    }

    public String deletePricingTier(PricingTier pricingTier, RequestOptions requestOptions) throws WarrantException {
        return this.deletePricingTier(pricingTier.getPricingTierId(), requestOptions);
    }

    public String deletePricingTier(String pricingTierId) throws WarrantException {
        return this.deletePricingTier(pricingTierId, new RequestOptions());
    }

    public String deletePricingTier(String pricingTierId, RequestOptions requestOptions) throws WarrantException {
        return this.deleteObject("pricing-tier", pricingTierId, requestOptions);
    }

    public PricingTier getPricingTier(String pricingTierId) throws WarrantException {
        return this.getPricingTier(pricingTierId, new RequestOptions());
    }

    public PricingTier getPricingTier(String pricingTierId, RequestOptions requestOptions) throws WarrantException {
        return this.getObject("pricing-tier", pricingTierId, PricingTier.class, requestOptions);
    }

    public ListResult<PricingTier> listPricingTiers(int limit) throws WarrantException {
        return this.listPricingTiers(new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<PricingTier> listPricingTiers(int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listPricingTiers(new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<PricingTier> listPricingTiers(ListParams listParams) throws WarrantException {
        return this.listPricingTiers(listParams, new RequestOptions());
    }

    public ListResult<PricingTier> listPricingTiers(ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        BaseWarrantObjectListResult pricingTierObjects = this.listObjects(new ObjectFilters().withObjectType("pricing-tier"), new ListParams().withLimit(10), requestOptions);
        PricingTier[] pricingTiers = (PricingTier[])Arrays.stream(pricingTierObjects.getResults()).map(result -> new PricingTier(result.getObjectId(), result.getMeta())).toArray(PricingTier[]::new);
        return new ListResult<PricingTier>(pricingTiers, pricingTierObjects.getPrevCursor(), pricingTierObjects.getNextCursor());
    }

    public ListResult<PricingTier> listPricingTiersForTenant(Tenant tenant, int limit) throws WarrantException {
        return this.listPricingTiersForTenant(tenant.getTenantId(), new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<PricingTier> listPricingTiersForTenant(Tenant tenant, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listPricingTiersForTenant(tenant.getTenantId(), new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<PricingTier> listPricingTiersForTenant(Tenant tenant, ListParams listParams) throws WarrantException {
        return this.listPricingTiersForTenant(tenant.getTenantId(), listParams, new RequestOptions());
    }

    public ListResult<PricingTier> listPricingTiersForTenant(Tenant tenant, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        return this.listPricingTiersForTenant(tenant.getTenantId(), listParams, requestOptions);
    }

    public ListResult<PricingTier> listPricingTiersForTenant(String tenantId, int limit) throws WarrantException {
        return this.listPricingTiersForTenant(tenantId, new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<PricingTier> listPricingTiersForTenant(String tenantId, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listPricingTiersForTenant(tenantId, new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<PricingTier> listPricingTiersForTenant(String tenantId, ListParams listParams) throws WarrantException {
        return this.listPricingTiersForTenant(tenantId, listParams, new RequestOptions());
    }

    public ListResult<PricingTier> listPricingTiersForTenant(String tenantId, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        QueryResultSet queryResultSet = this.query("select pricing-tier where tenant:" + tenantId + " is *", listParams, requestOptions);
        PricingTier[] pricingTiers = (PricingTier[])Arrays.stream(queryResultSet.getResults()).map(result -> new PricingTier(result.getObjectId(), result.getMeta())).toArray(PricingTier[]::new);
        return new ListResult<PricingTier>(pricingTiers, queryResultSet.getPrevCursor(), queryResultSet.getNextCursor());
    }

    public ListResult<PricingTier> listPricingTiersForUser(User user, int limit) throws WarrantException {
        return this.listPricingTiersForUser(user.getUserId(), new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<PricingTier> listPricingTiersForUser(User user, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listPricingTiersForUser(user.getUserId(), new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<PricingTier> listPricingTiersForUser(User user, ListParams listParams) throws WarrantException {
        return this.listPricingTiersForUser(user.getUserId(), listParams, new RequestOptions());
    }

    public ListResult<PricingTier> listPricingTiersForUser(User user, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        return this.listPricingTiersForUser(user.getUserId(), listParams, requestOptions);
    }

    public ListResult<PricingTier> listPricingTiersForUser(String userId, int limit) throws WarrantException {
        return this.listPricingTiersForUser(userId, new ListParams().withLimit(limit), new RequestOptions());
    }

    public ListResult<PricingTier> listPricingTiersForUser(String userId, int limit, RequestOptions requestOptions) throws WarrantException {
        return this.listPricingTiersForUser(userId, new ListParams().withLimit(limit), requestOptions);
    }

    public ListResult<PricingTier> listPricingTiersForUser(String userId, ListParams listParams) throws WarrantException {
        return this.listPricingTiersForUser(userId, listParams, new RequestOptions());
    }

    public ListResult<PricingTier> listPricingTiersForUser(String userId, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        QueryResultSet queryResultSet = this.query("select pricing-tier where user:" + userId + " is *", listParams, requestOptions);
        PricingTier[] pricingTiers = (PricingTier[])Arrays.stream(queryResultSet.getResults()).map(result -> new PricingTier(result.getObjectId(), result.getMeta())).toArray(PricingTier[]::new);
        return new ListResult<PricingTier>(pricingTiers, queryResultSet.getPrevCursor(), queryResultSet.getNextCursor());
    }

    public Warrant assignRoleToUser(Role role, User user) throws WarrantException {
        return this.assignRoleToUser(role.getRoleId(), user.getUserId(), new RequestOptions());
    }

    public Warrant assignRoleToUser(Role role, User user, RequestOptions requestOptions) throws WarrantException {
        return this.assignRoleToUser(role.getRoleId(), user.getUserId(), requestOptions);
    }

    public Warrant assignRoleToUser(String roleId, String userId) throws WarrantException {
        return this.assignRoleToUser(roleId, userId, new RequestOptions());
    }

    public Warrant assignRoleToUser(String roleId, String userId, RequestOptions requestOptions) throws WarrantException {
        return this.createWarrant((WarrantObject)new Role(roleId), "member", new WarrantSubject("user", userId), requestOptions);
    }

    public Warrant assignPermissionToUser(Permission permission, User user) throws WarrantException {
        return this.assignPermissionToUser(permission.getPermissionId(), user.getUserId(), new RequestOptions());
    }

    public Warrant assignPermissionToUser(Permission permission, User user, RequestOptions requestOptions) throws WarrantException {
        return this.assignPermissionToUser(permission.getPermissionId(), user.getUserId(), requestOptions);
    }

    public Warrant assignPermissionToUser(String permissionId, String userId) throws WarrantException {
        return this.assignPermissionToUser(permissionId, userId, new RequestOptions());
    }

    public Warrant assignPermissionToUser(String permissionId, String userId, RequestOptions requestOptions) throws WarrantException {
        return this.createWarrant((WarrantObject)new Permission(permissionId), "member", new WarrantSubject("user", userId), requestOptions);
    }

    public Warrant assignPricingTierToUser(PricingTier pricingTier, User user) throws WarrantException {
        return this.assignPricingTierToUser(pricingTier.getPricingTierId(), user.getUserId(), new RequestOptions());
    }

    public Warrant assignPricingTierToUser(PricingTier pricingTier, User user, RequestOptions requestOptions) throws WarrantException {
        return this.assignPricingTierToUser(pricingTier.getPricingTierId(), user.getUserId(), requestOptions);
    }

    public Warrant assignPricingTierToUser(String pricingTierId, String userId) throws WarrantException {
        return this.assignPricingTierToUser(pricingTierId, userId, new RequestOptions());
    }

    public Warrant assignPricingTierToUser(String pricingTierId, String userId, RequestOptions requestOptions) throws WarrantException {
        return this.createWarrant((WarrantObject)new PricingTier(pricingTierId), "member", new WarrantSubject("user", userId), requestOptions);
    }

    public Warrant assignFeatureToUser(Feature feature, User user) throws WarrantException {
        return this.assignFeatureToUser(feature.getFeatureId(), user.getUserId(), new RequestOptions());
    }

    public Warrant assignFeatureToUser(Feature feature, User user, RequestOptions requestOptions) throws WarrantException {
        return this.assignFeatureToUser(feature.getFeatureId(), user.getUserId(), requestOptions);
    }

    public Warrant assignFeatureToUser(String featureId, String userId) throws WarrantException {
        return this.assignFeatureToUser(featureId, userId, new RequestOptions());
    }

    public Warrant assignFeatureToUser(String featureId, String userId, RequestOptions requestOptions) throws WarrantException {
        return this.createWarrant((WarrantObject)new Feature(featureId), "member", new WarrantSubject("user", userId), requestOptions);
    }

    public Warrant assignUserToTenant(User user, Tenant tenant) throws WarrantException {
        return this.assignUserToTenant(user.getUserId(), tenant.getTenantId(), new RequestOptions());
    }

    public Warrant assignUserToTenant(User user, Tenant tenant, RequestOptions requestOptions) throws WarrantException {
        return this.assignUserToTenant(user.getUserId(), tenant.getTenantId(), requestOptions);
    }

    public Warrant assignUserToTenant(String userId, String tenantId) throws WarrantException {
        return this.assignUserToTenant(userId, tenantId, new RequestOptions());
    }

    public Warrant assignUserToTenant(String userId, String tenantId, RequestOptions requestOptions) throws WarrantException {
        return this.createWarrant((WarrantObject)new Tenant(tenantId), "member", new WarrantSubject("user", userId), requestOptions);
    }

    public Warrant assignPricingTierToTenant(PricingTier pricingTier, Tenant tenant) throws WarrantException {
        return this.assignPricingTierToTenant(pricingTier.getPricingTierId(), tenant.getTenantId(), new RequestOptions());
    }

    public Warrant assignPricingTierToTenant(PricingTier pricingTier, Tenant tenant, RequestOptions requestOptions) throws WarrantException {
        return this.assignPricingTierToTenant(pricingTier.getPricingTierId(), tenant.getTenantId(), requestOptions);
    }

    public Warrant assignPricingTierToTenant(String pricingTierId, String tenantId) throws WarrantException {
        return this.assignPricingTierToTenant(pricingTierId, tenantId, new RequestOptions());
    }

    public Warrant assignPricingTierToTenant(String pricingTierId, String tenantId, RequestOptions requestOptions) throws WarrantException {
        return this.createWarrant((WarrantObject)new PricingTier(pricingTierId), "member", new WarrantSubject("tenant", tenantId), requestOptions);
    }

    public Warrant assignFeatureToTenant(Feature feature, Tenant tenant) throws WarrantException {
        return this.assignFeatureToTenant(feature.getFeatureId(), tenant.getTenantId(), new RequestOptions());
    }

    public Warrant assignFeatureToTenant(Feature feature, Tenant tenant, RequestOptions requestOptions) throws WarrantException {
        return this.assignFeatureToTenant(feature.getFeatureId(), tenant.getTenantId(), requestOptions);
    }

    public Warrant assignFeatureToTenant(String featureId, String tenantId) throws WarrantException {
        return this.assignFeatureToTenant(featureId, tenantId, new RequestOptions());
    }

    public Warrant assignFeatureToTenant(String featureId, String tenantId, RequestOptions requestOptions) throws WarrantException {
        return this.createWarrant((WarrantObject)new Feature(featureId), "member", new WarrantSubject("tenant", tenantId), requestOptions);
    }

    public Warrant assignFeatureToPricingTier(Feature feature, PricingTier pricingTier) throws WarrantException {
        return this.assignFeatureToPricingTier(feature.getFeatureId(), pricingTier.getPricingTierId(), new RequestOptions());
    }

    public Warrant assignFeatureToPricingTier(Feature feature, PricingTier pricingTier, RequestOptions requestOptions) throws WarrantException {
        return this.assignFeatureToPricingTier(feature.getFeatureId(), pricingTier.getPricingTierId(), requestOptions);
    }

    public Warrant assignFeatureToPricingTier(String featureId, String pricingTierId) throws WarrantException {
        return this.assignFeatureToPricingTier(featureId, pricingTierId, new RequestOptions());
    }

    public Warrant assignFeatureToPricingTier(String featureId, String pricingTierId, RequestOptions requestOptions) throws WarrantException {
        return this.createWarrant((WarrantObject)new Feature(featureId), "member", new WarrantSubject("pricing-tier", pricingTierId), requestOptions);
    }

    public Warrant assignPermissionToRole(Permission permission, Role role) throws WarrantException {
        return this.assignPermissionToRole(permission.getPermissionId(), role.getRoleId(), new RequestOptions());
    }

    public Warrant assignPermissionToRole(Permission permission, Role role, RequestOptions requestOptions) throws WarrantException {
        return this.assignPermissionToRole(permission.getPermissionId(), role.getRoleId(), requestOptions);
    }

    public Warrant assignPermissionToRole(String permissionId, String roleId) throws WarrantException {
        return this.assignPermissionToRole(permissionId, roleId, new RequestOptions());
    }

    public Warrant assignPermissionToRole(String permissionId, String roleId, RequestOptions requestOptions) throws WarrantException {
        return this.createWarrant((WarrantObject)new Permission(permissionId), "member", new WarrantSubject("role", roleId), requestOptions);
    }

    public void removeRoleFromUser(Role role, User user) throws WarrantException {
        this.removeRoleFromUser(role.getRoleId(), user.getUserId(), new RequestOptions());
    }

    public void removeRoleFromUser(Role role, User user, RequestOptions requestOptions) throws WarrantException {
        this.removeRoleFromUser(role.getRoleId(), user.getUserId(), requestOptions);
    }

    public void removeRoleFromUser(String roleId, String userId) throws WarrantException {
        this.removeRoleFromUser(roleId, userId, new RequestOptions());
    }

    public void removeRoleFromUser(String roleId, String userId, RequestOptions requestOptions) throws WarrantException {
        this.deleteWarrant((WarrantObject)new Role(roleId), "member", new WarrantSubject("user", userId), requestOptions);
    }

    public void removePermissionFromUser(Permission permission, User user) throws WarrantException {
        this.removePermissionFromUser(permission.getPermissionId(), user.getUserId(), new RequestOptions());
    }

    public void removePermissionFromUser(Permission permission, User user, RequestOptions requestOptions) throws WarrantException {
        this.removePermissionFromUser(permission.getPermissionId(), user.getUserId(), requestOptions);
    }

    public void removePermissionFromUser(String permissionId, String userId) throws WarrantException {
        this.removePermissionFromUser(permissionId, userId, new RequestOptions());
    }

    public void removePermissionFromUser(String permissionId, String userId, RequestOptions requestOptions) throws WarrantException {
        this.deleteWarrant((WarrantObject)new Permission(permissionId), "member", new WarrantSubject("user", userId), requestOptions);
    }

    public void removePricingTierFromUser(PricingTier pricingTier, User user) throws WarrantException {
        this.removePricingTierFromUser(pricingTier.getPricingTierId(), user.getUserId(), new RequestOptions());
    }

    public void removePricingTierFromUser(PricingTier pricingTier, User user, RequestOptions requestOptions) throws WarrantException {
        this.removePricingTierFromUser(pricingTier.getPricingTierId(), user.getUserId(), requestOptions);
    }

    public void removePricingTierFromUser(String pricingTierId, String userId) throws WarrantException {
        this.removePricingTierFromUser(pricingTierId, userId, new RequestOptions());
    }

    public void removePricingTierFromUser(String pricingTierId, String userId, RequestOptions requestOptions) throws WarrantException {
        this.deleteWarrant((WarrantObject)new PricingTier(pricingTierId), "member", new WarrantSubject("user", userId), requestOptions);
    }

    public void removeFeatureFromUser(Feature feature, User user) throws WarrantException {
        this.removeFeatureFromUser(feature.getFeatureId(), user.getUserId(), new RequestOptions());
    }

    public void removeFeatureFromUser(Feature feature, User user, RequestOptions requestOptions) throws WarrantException {
        this.removeFeatureFromUser(feature.getFeatureId(), user.getUserId(), requestOptions);
    }

    public void removeFeatureFromUser(String featureId, String userId) throws WarrantException {
        this.removeFeatureFromUser(featureId, userId, new RequestOptions());
    }

    public void removeFeatureFromUser(String featureId, String userId, RequestOptions requestOptions) throws WarrantException {
        this.deleteWarrant((WarrantObject)new Feature(featureId), "member", new WarrantSubject("user", userId), requestOptions);
    }

    public void removeUserFromTenant(User user, Tenant tenant) throws WarrantException {
        this.removeUserFromTenant(user.getUserId(), tenant.getTenantId(), new RequestOptions());
    }

    public void removeUserFromTenant(User user, Tenant tenant, RequestOptions requestOptions) throws WarrantException {
        this.removeUserFromTenant(user.getUserId(), tenant.getTenantId(), requestOptions);
    }

    public void removeUserFromTenant(String userId, String tenantId) throws WarrantException {
        this.removeUserFromTenant(userId, tenantId, new RequestOptions());
    }

    public void removeUserFromTenant(String userId, String tenantId, RequestOptions requestOptions) throws WarrantException {
        this.deleteWarrant((WarrantObject)new Tenant(tenantId), "member", new WarrantSubject("user", userId), requestOptions);
    }

    public void removePricingTierFromTenant(PricingTier pricingTier, Tenant tenant) throws WarrantException {
        this.removePricingTierFromTenant(pricingTier.getPricingTierId(), tenant.getTenantId(), new RequestOptions());
    }

    public void removePricingTierFromTenant(PricingTier pricingTier, Tenant tenant, RequestOptions requestOptions) throws WarrantException {
        this.removePricingTierFromTenant(pricingTier.getPricingTierId(), tenant.getTenantId(), requestOptions);
    }

    public void removePricingTierFromTenant(String pricingTierId, String tenantId) throws WarrantException {
        this.removePricingTierFromTenant(pricingTierId, tenantId, new RequestOptions());
    }

    public void removePricingTierFromTenant(String pricingTierId, String tenantId, RequestOptions requestOptions) throws WarrantException {
        this.deleteWarrant((WarrantObject)new PricingTier(pricingTierId), "member", new WarrantSubject("tenant", tenantId), requestOptions);
    }

    public void removeFeatureFromTenant(Feature feature, Tenant tenant) throws WarrantException {
        this.removeFeatureFromTenant(feature.getFeatureId(), tenant.getTenantId(), new RequestOptions());
    }

    public void removeFeatureFromTenant(Feature feature, Tenant tenant, RequestOptions requestOptions) throws WarrantException {
        this.removeFeatureFromTenant(feature.getFeatureId(), tenant.getTenantId(), requestOptions);
    }

    public void removeFeatureFromTenant(String featureId, String tenantId) throws WarrantException {
        this.removeFeatureFromTenant(featureId, tenantId, new RequestOptions());
    }

    public void removeFeatureFromTenant(String featureId, String tenantId, RequestOptions requestOptions) throws WarrantException {
        this.deleteWarrant((WarrantObject)new Feature(featureId), "member", new WarrantSubject("tenant", tenantId), requestOptions);
    }

    public void removeFeatureFromPricingTier(Feature feature, PricingTier pricingTier) throws WarrantException {
        this.removeFeatureFromPricingTier(feature.getFeatureId(), pricingTier.getPricingTierId(), new RequestOptions());
    }

    public void removeFeatureFromPricingTier(Feature feature, PricingTier pricingTier, RequestOptions requestOptions) throws WarrantException {
        this.removeFeatureFromPricingTier(feature.getFeatureId(), pricingTier.getPricingTierId(), requestOptions);
    }

    public void removeFeatureFromPricingTier(String featureId, String pricingTierId) throws WarrantException {
        this.removeFeatureFromPricingTier(featureId, pricingTierId, new RequestOptions());
    }

    public void removeFeatureFromPricingTier(String featureId, String pricingTierId, RequestOptions requestOptions) throws WarrantException {
        this.deleteWarrant((WarrantObject)new Feature(featureId), "member", new WarrantSubject("pricing-tier", pricingTierId), requestOptions);
    }

    public void removePermissionFromRole(Permission permission, Role role) throws WarrantException {
        this.removePermissionFromRole(permission.getPermissionId(), role.getRoleId(), new RequestOptions());
    }

    public void removePermissionFromRole(Permission permission, Role role, RequestOptions requestOptions) throws WarrantException {
        this.removePermissionFromRole(permission.getPermissionId(), role.getRoleId(), requestOptions);
    }

    public void removePermissionFromRole(String permissionId, String roleId) throws WarrantException {
        this.removePermissionFromRole(permissionId, roleId, new RequestOptions());
    }

    public void removePermissionFromRole(String permissionId, String roleId, RequestOptions requestOptions) throws WarrantException {
        this.deleteWarrant((WarrantObject)new Permission(permissionId), "member", new WarrantSubject("role", roleId), requestOptions);
    }

    public boolean checkUserHasPermission(User user, String permissionId) throws WarrantException {
        return this.checkUserHasPermission(user.getUserId(), permissionId, new RequestOptions());
    }

    public boolean checkUserHasPermission(User user, String permissionId, RequestOptions requestOptions) throws WarrantException {
        return this.checkUserHasPermission(user.getUserId(), permissionId, requestOptions);
    }

    public boolean checkUserHasPermission(String userId, String permissionId) throws WarrantException {
        return this.checkUserHasPermission(userId, permissionId, new RequestOptions());
    }

    public boolean checkUserHasPermission(String userId, String permissionId, RequestOptions requestOptions) throws WarrantException {
        Permission perm = new Permission();
        perm.setPermissionId(permissionId);
        WarrantSubject subject = new WarrantSubject("user", userId);
        return this.check((WarrantObject)perm, "member", subject, requestOptions);
    }

    public boolean checkTenantHasFeature(Tenant tenant, String featureId) throws WarrantException {
        return this.checkTenantHasFeature(tenant.getTenantId(), featureId, new RequestOptions());
    }

    public boolean checkTenantHasFeature(Tenant tenant, String featureId, RequestOptions requestOptions) throws WarrantException {
        return this.checkTenantHasFeature(tenant.getTenantId(), featureId, requestOptions);
    }

    public boolean checkTenantHasFeature(String tenantId, String featureId) throws WarrantException {
        return this.checkTenantHasFeature(tenantId, featureId, new RequestOptions());
    }

    public boolean checkTenantHasFeature(String tenantId, String featureId, RequestOptions requestOptions) throws WarrantException {
        Feature feature = new Feature();
        feature.setFeatureId(featureId);
        WarrantSubject subject = new WarrantSubject("tenant", tenantId);
        return this.check((WarrantObject)feature, "member", subject, requestOptions);
    }

    public boolean checkUserHasFeature(User user, String featureId) throws WarrantException {
        return this.checkUserHasFeature(user.getUserId(), featureId, new RequestOptions());
    }

    public boolean checkUserHasFeature(User user, String featureId, RequestOptions requestOptions) throws WarrantException {
        return this.checkUserHasFeature(user.getUserId(), featureId, requestOptions);
    }

    public boolean checkUserHasFeature(String userId, String featureId) throws WarrantException {
        return this.checkUserHasFeature(userId, featureId, new RequestOptions());
    }

    public boolean checkUserHasFeature(String userId, String featureId, RequestOptions requestOptions) throws WarrantException {
        Feature feature = new Feature();
        feature.setFeatureId(featureId);
        WarrantSubject subject = new WarrantSubject("user", userId);
        return this.check((WarrantObject)feature, "member", subject, requestOptions);
    }
}

