/*
 * Decompiled with CFR 0.152.
 */
package dev.warrant.model.object;

import dev.warrant.model.object.BaseWarrantObject;
import java.util.Map;

public class Role
extends BaseWarrantObject {
    public static final String OBJECT_TYPE = "role";
    static final String NAME_KEY = "name";
    static final String DESCRIPTION_KEY = "description";

    public Role() {
    }

    public Role(String roleId) {
        super(OBJECT_TYPE, roleId);
    }

    public Role(String roleId, String name) {
        super(OBJECT_TYPE, roleId);
        this.meta.put(NAME_KEY, name);
    }

    public Role(String roleId, String name, String description) {
        super(OBJECT_TYPE, roleId);
        this.meta.put(NAME_KEY, name);
        this.meta.put(DESCRIPTION_KEY, description);
    }

    public Role(String roleId, Map<String, Object> meta) {
        super(OBJECT_TYPE, roleId, meta);
    }

    public String getRoleId() {
        return this.objectId;
    }

    public void setRoleId(String roleId) {
        this.objectId = roleId;
    }

    public String getName() {
        if (this.meta != null) {
            if (this.meta.containsKey(NAME_KEY)) {
                return this.meta.get(NAME_KEY).toString();
            }
            return "";
        }
        return "";
    }

    public void setName(String name) {
        this.meta.put(NAME_KEY, name);
    }

    public String getDescription() {
        if (this.meta != null) {
            if (this.meta.containsKey(DESCRIPTION_KEY)) {
                return this.meta.get(DESCRIPTION_KEY).toString();
            }
            return "";
        }
        return "";
    }

    public void setDescription(String description) {
        this.meta.put(DESCRIPTION_KEY, description);
    }

    @Override
    public String id() {
        return this.objectId;
    }

    @Override
    public String type() {
        return OBJECT_TYPE;
    }
}

