/*
 * Decompiled with CFR 0.152.
 */
package dev.warrant.model.object;

import dev.warrant.model.object.BaseWarrantObject;
import java.util.Map;

public class Permission
extends BaseWarrantObject {
    public static final String OBJECT_TYPE = "permission";
    static final String NAME_KEY = "name";
    static final String DESCRIPTION_KEY = "description";

    public Permission() {
    }

    public Permission(String permissionId) {
        super(OBJECT_TYPE, permissionId);
    }

    public Permission(String permissionId, String name, String description) {
        super(OBJECT_TYPE, permissionId);
        this.meta.put(NAME_KEY, name);
        this.meta.put(DESCRIPTION_KEY, description);
    }

    public Permission(String permissionId, Map<String, Object> meta) {
        super(OBJECT_TYPE, permissionId, meta);
    }

    public String getPermissionId() {
        return this.objectId;
    }

    public void setPermissionId(String permissionId) {
        this.objectId = permissionId;
    }

    public String getName() {
        if (this.meta != null) {
            if (this.meta.containsKey(NAME_KEY)) {
                return this.meta.get(NAME_KEY).toString();
            }
            return "";
        }
        return "";
    }

    public void setName(String name) {
        this.meta.put(NAME_KEY, name);
    }

    public String getDescription() {
        if (this.meta != null) {
            if (this.meta.containsKey(DESCRIPTION_KEY)) {
                return this.meta.get(DESCRIPTION_KEY).toString();
            }
            return "";
        }
        return "";
    }

    public void setDescription(String description) {
        this.meta.put(DESCRIPTION_KEY, description);
    }

    @Override
    public String id() {
        return this.objectId;
    }

    @Override
    public String type() {
        return OBJECT_TYPE;
    }
}

