/*
 * Decompiled with CFR 0.152.
 */
package dev.warrant;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.warrant.ListParams;
import dev.warrant.ObjectFilters;
import dev.warrant.RequestOptions;
import dev.warrant.WarrantConfig;
import dev.warrant.WarrantFilters;
import dev.warrant.exception.WarrantException;
import dev.warrant.model.QueryResultSet;
import dev.warrant.model.UserSession;
import dev.warrant.model.UserSessionSpec;
import dev.warrant.model.Warrant;
import dev.warrant.model.WarrantCheck;
import dev.warrant.model.WarrantCheckSpec;
import dev.warrant.model.WarrantSpec;
import dev.warrant.model.WarrantSubject;
import dev.warrant.model.object.BaseWarrantObject;
import dev.warrant.model.object.BaseWarrantObjectListResult;
import dev.warrant.model.object.WarrantListResult;
import dev.warrant.model.object.WarrantObject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

public class WarrantBaseClient {
    public static final String SDK_VERSION = "4.1.0";
    public static final String USER_AGENT = "warrant-java/4.1.0";
    public static final Integer MAX_RETRIES = 2;
    public static final Duration MINIMUM_SLEEP_TIME = Duration.ofMillis(500L);
    public static final Double BACKOFF_MULTIPLIER = 1.5;
    final HttpClient client;
    final WarrantConfig config;
    final ObjectMapper mapper;

    WarrantBaseClient(WarrantConfig config, HttpClient client) {
        this.config = config;
        this.client = client;
        this.mapper = new ObjectMapper();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public WarrantBaseClient(WarrantConfig config) {
        this(config, HttpClient.newHttpClient());
    }

    public Warrant createWarrant(WarrantObject object, String relation, WarrantSubject subject) throws WarrantException {
        return this.createWarrant(object, relation, subject, "", new RequestOptions());
    }

    public Warrant createWarrant(WarrantObject object, String relation, WarrantSubject subject, RequestOptions requestOptions) throws WarrantException {
        return this.createWarrant(object, relation, subject, "", requestOptions);
    }

    public Warrant createWarrant(WarrantObject object, String relation, WarrantSubject subject, String policy) throws WarrantException {
        return this.createWarrant(object, relation, subject, policy, new RequestOptions());
    }

    public Warrant createWarrant(WarrantObject object, String relation, WarrantSubject subject, String policy, RequestOptions requestOptions) throws WarrantException {
        Warrant toCreate = new Warrant(object.type(), object.id(), relation, subject, policy);
        return this.makePostRequest("/v2/warrants", toCreate, Warrant.class, requestOptions.asMap());
    }

    public Warrant[] createWarrants(Warrant[] warrants) throws WarrantException {
        return this.createWarrants(warrants, new RequestOptions());
    }

    public Warrant[] createWarrants(Warrant[] warrants, RequestOptions requestOptions) throws WarrantException {
        return this.makePostRequest("/v2/warrants", warrants, Warrant[].class, requestOptions.asMap());
    }

    public String deleteWarrant(WarrantObject object, String relation, WarrantSubject subject) throws WarrantException {
        return this.deleteWarrant(object, relation, subject, "", new RequestOptions());
    }

    public String deleteWarrant(WarrantObject object, String relation, WarrantSubject subject, RequestOptions requestOptions) throws WarrantException {
        return this.deleteWarrant(object, relation, subject, "", requestOptions);
    }

    public String deleteWarrant(WarrantObject object, String relation, WarrantSubject subject, String policy) throws WarrantException {
        return this.deleteWarrant(object, relation, subject, policy, new RequestOptions());
    }

    public String deleteWarrant(WarrantObject object, String relation, WarrantSubject subject, String policy, RequestOptions requestOptions) throws WarrantException {
        Warrant toDelete = new Warrant(object.type(), object.id(), relation, subject, policy);
        return this.makeDeleteRequest("/v2/warrants", toDelete, requestOptions.asMap());
    }

    public String deleteWarrants(Warrant[] warrants) throws WarrantException {
        return this.deleteWarrants(warrants, new RequestOptions());
    }

    public String deleteWarrants(Warrant[] warrants, RequestOptions requestOptions) throws WarrantException {
        return this.makeDeleteRequest("/v2/warrants", warrants, requestOptions.asMap());
    }

    public WarrantListResult listWarrants(WarrantFilters filters, ListParams listParams) throws WarrantException {
        return this.listWarrants(filters, listParams, new RequestOptions());
    }

    public WarrantListResult listWarrants(WarrantFilters filters, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        Map<String, Object> queryParams = filters.asMap();
        queryParams.putAll(listParams.asMap());
        return this.makeGetRequest("/v2/warrants", queryParams, WarrantListResult.class, requestOptions.asMap());
    }

    public QueryResultSet query(String query, ListParams listParams) throws WarrantException {
        return this.query(query, listParams, new RequestOptions());
    }

    public QueryResultSet query(String query, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        Map<String, Object> queryParams = listParams.asMap();
        queryParams.put("q", query);
        return this.makeGetRequest("/v2/query", queryParams, QueryResultSet.class, requestOptions.asMap());
    }

    public boolean check(WarrantObject object, String relation, WarrantSubject subject) throws WarrantException {
        return this.check(object, relation, subject, Collections.emptyMap(), new RequestOptions());
    }

    public boolean check(WarrantObject object, String relation, WarrantSubject subject, RequestOptions requestOptions) throws WarrantException {
        return this.check(object, relation, subject, Collections.emptyMap(), requestOptions);
    }

    public boolean check(WarrantObject object, String relation, WarrantSubject subject, Map<String, Object> context) throws WarrantException {
        return this.check(object, relation, subject, context, new RequestOptions());
    }

    public boolean check(WarrantObject object, String relation, WarrantSubject subject, Map<String, Object> context, RequestOptions requestOptions) throws WarrantException {
        WarrantCheckSpec toCheck = new WarrantCheckSpec(Arrays.asList(new WarrantSpec(object.type(), object.id(), relation, subject, context)));
        WarrantCheck result = this.makeCheckRequest(toCheck, requestOptions.asMap());
        return result.getCode() == 200 && "Authorized".equals(result.getResult());
    }

    public List<WarrantCheck> checkBatch(List<WarrantSpec> warrants) throws WarrantException {
        return this.checkBatch(warrants, new RequestOptions());
    }

    public List<WarrantCheck> checkBatch(List<WarrantSpec> warrants, RequestOptions requestOptions) throws WarrantException {
        WarrantCheck[] results = this.checkWithOp(warrants, "batch", WarrantCheck[].class, requestOptions);
        return Arrays.asList(results);
    }

    public WarrantCheck checkAnyOf(List<WarrantSpec> warrants) throws WarrantException {
        return this.checkAnyOf(warrants, new RequestOptions());
    }

    public WarrantCheck checkAnyOf(List<WarrantSpec> warrants, RequestOptions requestOptions) throws WarrantException {
        return this.checkWithOp(warrants, "anyOf", WarrantCheck.class, requestOptions);
    }

    public WarrantCheck checkAllOf(List<WarrantSpec> warrants) throws WarrantException {
        return this.checkAllOf(warrants, new RequestOptions());
    }

    public WarrantCheck checkAllOf(List<WarrantSpec> warrants, RequestOptions requestOptions) throws WarrantException {
        return this.checkWithOp(warrants, "allOf", WarrantCheck.class, new RequestOptions());
    }

    public BaseWarrantObject createObject(BaseWarrantObject object) throws WarrantException {
        return this.createObject(object, new RequestOptions());
    }

    public BaseWarrantObject createObject(BaseWarrantObject object, RequestOptions requestOptions) throws WarrantException {
        return this.createObject(object.type(), object.id(), Collections.emptyMap(), requestOptions);
    }

    public BaseWarrantObject createObject(BaseWarrantObject object, Map<String, Object> meta) throws WarrantException {
        return this.createObject(object, meta, new RequestOptions());
    }

    public BaseWarrantObject createObject(BaseWarrantObject object, Map<String, Object> meta, RequestOptions requestOptions) throws WarrantException {
        return this.createObject(object.type(), object.id(), meta, requestOptions);
    }

    public <T extends WarrantObject> T createObject(T object, Class<T> resultType) throws WarrantException {
        return this.createObject(object.type(), object.id(), Collections.emptyMap(), resultType, new RequestOptions());
    }

    public <T extends WarrantObject> T createObject(T object, Class<T> resultType, RequestOptions requestOptions) throws WarrantException {
        return this.createObject(object.type(), object.id(), Collections.emptyMap(), resultType, requestOptions);
    }

    public <T extends WarrantObject> T createObject(T object, Map<String, Object> meta, Class<T> resultType) throws WarrantException {
        return this.createObject(object.type(), object.id(), meta, resultType, new RequestOptions());
    }

    public <T extends WarrantObject> T createObject(T object, Map<String, Object> meta, Class<T> resultType, RequestOptions requestOptions) throws WarrantException {
        return this.createObject(object.type(), object.id(), meta, resultType, requestOptions);
    }

    public BaseWarrantObject createObject(String objectType) throws WarrantException {
        return this.createObject(objectType, null, Collections.emptyMap(), BaseWarrantObject.class, new RequestOptions());
    }

    public BaseWarrantObject createObject(String objectType, RequestOptions requestOptions) throws WarrantException {
        return this.createObject(objectType, null, Collections.emptyMap(), BaseWarrantObject.class, requestOptions);
    }

    public <T extends WarrantObject> T createObject(String objectType, Class<T> resultType) throws WarrantException {
        return this.createObject(objectType, null, Collections.emptyMap(), resultType, new RequestOptions());
    }

    public <T extends WarrantObject> T createObject(String objectType, Class<T> resultType, RequestOptions requestOptions) throws WarrantException {
        return this.createObject(objectType, null, Collections.emptyMap(), resultType, requestOptions);
    }

    public BaseWarrantObject createObject(String objectType, Map<String, Object> meta) throws WarrantException {
        return this.createObject(objectType, null, meta, BaseWarrantObject.class, new RequestOptions());
    }

    public BaseWarrantObject createObject(String objectType, Map<String, Object> meta, RequestOptions requestOptions) throws WarrantException {
        return this.createObject(objectType, null, meta, BaseWarrantObject.class, requestOptions);
    }

    public <T extends WarrantObject> T createObject(String objectType, Map<String, Object> meta, Class<T> resultType) throws WarrantException {
        return this.createObject(objectType, null, meta, resultType, new RequestOptions());
    }

    public <T extends WarrantObject> T createObject(String objectType, Map<String, Object> meta, Class<T> resultType, RequestOptions requestOptions) throws WarrantException {
        return this.createObject(objectType, null, meta, resultType, requestOptions);
    }

    public BaseWarrantObject createObject(String objectType, String objectId) throws WarrantException {
        return this.createObject(objectType, objectId, Collections.emptyMap(), BaseWarrantObject.class, new RequestOptions());
    }

    public BaseWarrantObject createObject(String objectType, String objectId, RequestOptions requestOptions) throws WarrantException {
        return this.createObject(objectType, objectId, Collections.emptyMap(), BaseWarrantObject.class, requestOptions);
    }

    public <T extends WarrantObject> T createObject(String objectType, String objectId, Class<T> resultType) throws WarrantException {
        return this.createObject(objectType, objectId, Collections.emptyMap(), resultType, new RequestOptions());
    }

    public <T extends WarrantObject> T createObject(String objectType, String objectId, Class<T> resultType, RequestOptions requestOptions) throws WarrantException {
        return this.createObject(objectType, objectId, Collections.emptyMap(), resultType, requestOptions);
    }

    public BaseWarrantObject createObject(String objectType, String objectId, Map<String, Object> meta) throws WarrantException {
        return this.createObject(objectType, objectId, meta, BaseWarrantObject.class, new RequestOptions());
    }

    public BaseWarrantObject createObject(String objectType, String objectId, Map<String, Object> meta, RequestOptions requestOptions) throws WarrantException {
        return this.createObject(objectType, objectId, meta, BaseWarrantObject.class, requestOptions);
    }

    public <T extends WarrantObject> T createObject(String objectType, String objectId, Map<String, Object> meta, Class<T> resultType) throws WarrantException {
        return this.createObject(objectType, objectId, meta, resultType, new RequestOptions());
    }

    public <T extends WarrantObject> T createObject(String objectType, String objectId, Map<String, Object> meta, Class<T> resultType, RequestOptions requestOptions) throws WarrantException {
        BaseWarrantObject obj = new BaseWarrantObject(objectType, objectId, meta);
        return (T)((WarrantObject)this.makePostRequest("/v2/objects", obj, resultType, requestOptions.asMap()));
    }

    public BaseWarrantObject[] createObjects(BaseWarrantObject[] objects) throws WarrantException {
        return this.createObjects(objects, new RequestOptions());
    }

    public BaseWarrantObject[] createObjects(BaseWarrantObject[] objects, RequestOptions requestOptions) throws WarrantException {
        return (BaseWarrantObject[])this.createObjects(objects, BaseWarrantObject[].class, requestOptions);
    }

    public <T extends WarrantObject> T[] createObjects(T[] objects, Class<T[]> resultType) throws WarrantException {
        return this.createObjects((WarrantObject[])objects, resultType, new RequestOptions());
    }

    public <T extends WarrantObject> T[] createObjects(T[] objects, Class<T[]> resultType, RequestOptions requestOptions) throws WarrantException {
        BaseWarrantObject[] baseObjects = (BaseWarrantObject[])Arrays.stream(objects).map(object -> new BaseWarrantObject(object.type(), object.id(), object.meta())).toArray(BaseWarrantObject[]::new);
        return (WarrantObject[])this.makePostRequest("/v2/objects", baseObjects, resultType, requestOptions.asMap());
    }

    public BaseWarrantObject getObject(String objectType, String objectId) throws WarrantException {
        return this.getObject(objectType, objectId, BaseWarrantObject.class, new RequestOptions());
    }

    public BaseWarrantObject getObject(String objectType, String objectId, RequestOptions requestOptions) throws WarrantException {
        return this.getObject(objectType, objectId, BaseWarrantObject.class, requestOptions);
    }

    public <T extends WarrantObject> T getObject(String objectType, String objectId, Class<T> resultType) throws WarrantException {
        return this.getObject(objectType, objectId, resultType, new RequestOptions());
    }

    public <T extends WarrantObject> T getObject(String objectType, String objectId, Class<T> resultType, RequestOptions requestOptions) throws WarrantException {
        return (T)((WarrantObject)this.makeGetRequest("/v2/objects/" + objectType + "/" + objectId, resultType, requestOptions.asMap()));
    }

    public BaseWarrantObject updateObject(String objectType, String objectId, Map<String, Object> meta) throws WarrantException {
        return this.updateObject(objectType, objectId, meta, BaseWarrantObject.class, new RequestOptions());
    }

    public BaseWarrantObject updateObject(String objectType, String objectId, Map<String, Object> meta, RequestOptions requestOptions) throws WarrantException {
        return this.updateObject(objectType, objectId, meta, BaseWarrantObject.class, requestOptions);
    }

    public <T extends WarrantObject> T updateObject(String objectType, String objectId, Map<String, Object> meta, Class<T> resultType) throws WarrantException {
        return this.updateObject(objectType, objectId, meta, resultType, new RequestOptions());
    }

    public <T extends WarrantObject> T updateObject(String objectType, String objectId, Map<String, Object> meta, Class<T> resultType, RequestOptions requestOptions) throws WarrantException {
        BaseWarrantObject obj = new BaseWarrantObject(objectType, objectId, meta);
        return (T)((WarrantObject)this.makePutRequest("/v2/objects/" + objectType + "/" + objectId, obj, resultType, requestOptions.asMap()));
    }

    public String deleteObject(WarrantObject obj) throws WarrantException {
        return this.deleteObject(obj.type(), obj.id(), new RequestOptions());
    }

    public String deleteObject(WarrantObject obj, RequestOptions requestOptions) throws WarrantException {
        return this.deleteObject(obj.type(), obj.id(), requestOptions);
    }

    public String deleteObject(String objectType, String objectId) throws WarrantException {
        return this.deleteObject(objectType, objectId, new RequestOptions());
    }

    public String deleteObject(String objectType, String objectId, RequestOptions requestOptions) throws WarrantException {
        return this.makeDeleteRequest("/v2/objects/" + objectType + "/" + objectId, requestOptions.asMap());
    }

    public String deleteObjects(BaseWarrantObject[] objects) throws WarrantException {
        return this.deleteObjects(objects, new RequestOptions());
    }

    public String deleteObjects(BaseWarrantObject[] objects, RequestOptions requestOptions) throws WarrantException {
        return this.makeDeleteRequest("/v2/objects", objects, requestOptions.asMap());
    }

    public <T extends WarrantObject> String deleteObjects(T[] objects) throws WarrantException {
        return this.deleteObjects((WarrantObject[])objects, new RequestOptions());
    }

    public <T extends WarrantObject> String deleteObjects(T[] objects, RequestOptions requestOptions) throws WarrantException {
        BaseWarrantObject[] baseObjects = (BaseWarrantObject[])Arrays.stream(objects).map(object -> new BaseWarrantObject(object.type(), object.id())).toArray(BaseWarrantObject[]::new);
        return this.makeDeleteRequest("/v2/objects", baseObjects, requestOptions.asMap());
    }

    public BaseWarrantObjectListResult listObjects(ObjectFilters filters, ListParams listParams) throws WarrantException {
        return this.listObjects(filters, listParams, new RequestOptions());
    }

    public BaseWarrantObjectListResult listObjects(ObjectFilters filters, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        Map<String, Object> queryParams = filters.asMap();
        queryParams.putAll(listParams.asMap());
        return this.makeGetRequest("/v2/objects", queryParams, BaseWarrantObjectListResult.class, requestOptions.asMap());
    }

    public String createUserAuthzSession(String userId) throws WarrantException {
        return this.createUserAuthzSession(userId, new RequestOptions());
    }

    public String createUserAuthzSession(String userId, RequestOptions requestOptions) throws WarrantException {
        UserSession sess = this.makePostRequest("/v2/sessions", UserSessionSpec.newAuthorizationSessionSpec(userId), UserSession.class, requestOptions.asMap());
        return sess.getToken();
    }

    public String createUserSelfServiceDashboardUrl(String userId, String tenantId, String selfServiceStrategy, String redirectUrl) throws WarrantException {
        return this.createUserSelfServiceDashboardUrl(userId, tenantId, selfServiceStrategy, redirectUrl, new RequestOptions());
    }

    public String createUserSelfServiceDashboardUrl(String userId, String tenantId, String selfServiceStrategy, String redirectUrl, RequestOptions requestOptions) throws WarrantException {
        UserSession ssdash = this.makePostRequest("/v2/sessions", UserSessionSpec.newSelfServiceDashboardSessionSpec(userId, tenantId, selfServiceStrategy), UserSession.class, requestOptions.asMap());
        return this.config.getSelfServiceDashboardBaseUrl() + "/" + ssdash.getToken() + "?redirectUrl=" + redirectUrl;
    }

    WarrantCheck makeCheckRequest(WarrantCheckSpec toCheck) throws WarrantException {
        return this.makeCheckRequest(toCheck, Collections.emptyMap());
    }

    WarrantCheck makeCheckRequest(WarrantCheckSpec toCheck, Map<String, Object> requestOptions) throws WarrantException {
        try {
            String payload = this.mapper.writeValueAsString((Object)toCheck);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getCheckUrl() + "/v2/check")).POST(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            for (Map.Entry<String, Object> requestOption : requestOptions.entrySet()) {
                requestBuilder.header(requestOption.getKey(), requestOption.getValue().toString());
            }
            HttpRequest req = requestBuilder.build();
            HttpResponse<String> resp = this.makeRequestWithRetry(req, HttpResponse.BodyHandlers.ofString());
            int statusCode = resp.statusCode();
            if (statusCode >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return (WarrantCheck)this.mapper.readValue(resp.body(), WarrantCheck.class);
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T checkWithOp(List<WarrantSpec> warrants, String op, Class<T> type, RequestOptions requestOptions) throws WarrantException {
        try {
            WarrantCheckSpec toCheck = new WarrantCheckSpec(warrants, op);
            String payload = this.mapper.writeValueAsString((Object)toCheck);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getCheckUrl() + "/v2/check")).POST(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            for (Map.Entry<String, Object> requestOption : requestOptions.asMap().entrySet()) {
                requestBuilder.header(requestOption.getKey(), requestOption.getValue().toString());
            }
            HttpRequest req = requestBuilder.build();
            HttpResponse<String> resp = this.makeRequestWithRetry(req, HttpResponse.BodyHandlers.ofString());
            int statusCode = resp.statusCode();
            if (statusCode >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return (T)this.mapper.readValue(resp.body(), type);
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makePostRequest(String uri, Object reqPayload, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makePostRequest(uri, reqPayload);
            if (type.isArray()) {
                Map[] responseBody = (Map[])this.mapper.readValue(resp.body(), (TypeReference)new TypeReference<Map<String, Object>[]>(){});
                Optional<String> warrantToken = resp.headers().firstValue("warrant-token");
                for (Map map : responseBody) {
                    warrantToken.ifPresent(token -> map.put("warrantToken", token));
                }
                return (T)this.mapper.readValue(this.mapper.writeValueAsString((Object)responseBody), type);
            }
            Map responseBody = (Map)this.mapper.readValue(resp.body(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            Optional<String> warrantToken = resp.headers().firstValue("warrant-token");
            warrantToken.ifPresent(token -> responseBody.put("warrantToken", token));
            return (T)this.mapper.readValue(this.mapper.writeValueAsString((Object)responseBody), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makePostRequest(String uri, Object reqPayload, Class<T> type, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makePostRequest(uri, reqPayload);
            if (type.isArray()) {
                Map[] responseBody = (Map[])this.mapper.readValue(resp.body(), (TypeReference)new TypeReference<Map<String, Object>[]>(){});
                Optional<String> warrantToken = resp.headers().firstValue("warrant-token");
                for (Map map : responseBody) {
                    warrantToken.ifPresent(token -> map.put("warrantToken", token));
                }
                return (T)this.mapper.readValue(this.mapper.writeValueAsString((Object)responseBody), type);
            }
            Map responseBody = (Map)this.mapper.readValue(resp.body(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            Optional<String> warrantToken = resp.headers().firstValue("warrant-token");
            warrantToken.ifPresent(token -> responseBody.put("warrantToken", token));
            return (T)this.mapper.readValue(this.mapper.writeValueAsString((Object)responseBody), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    HttpResponse<String> makePostRequest(String uri, Object reqPayload) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> resp;
            int statusCode;
            String payload = this.mapper.writeValueAsString(reqPayload);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + uri)).POST(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (resp = this.makeRequestWithRetry(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    HttpResponse<String> makePostRequest(String uri, Object reqPayload, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> resp;
            int statusCode;
            String payload = this.mapper.writeValueAsString(reqPayload);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + uri)).POST(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            for (Map.Entry<String, Object> requestOption : requestOptions.entrySet()) {
                requestBuilder.header(requestOption.getKey(), requestOption.getValue().toString());
            }
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (resp = this.makeRequestWithRetry(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makePutRequest(String uri, Object reqPayload, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makePutRequest(uri, reqPayload);
            if (type.isArray()) {
                Map[] responseBody = (Map[])this.mapper.readValue(resp.body(), (TypeReference)new TypeReference<Map<String, Object>[]>(){});
                Optional<String> warrantToken = resp.headers().firstValue("warrant-token");
                for (Map map : responseBody) {
                    warrantToken.ifPresent(token -> map.put("warrantToken", token));
                }
                return (T)this.mapper.readValue(this.mapper.writeValueAsString((Object)responseBody), type);
            }
            Map responseBody = (Map)this.mapper.readValue(resp.body(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            Optional<String> warrantToken = resp.headers().firstValue("warrant-token");
            warrantToken.ifPresent(token -> responseBody.put("warrantToken", token));
            return (T)this.mapper.readValue(this.mapper.writeValueAsString((Object)responseBody), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makePutRequest(String uri, Object reqPayload, Class<T> type, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makePutRequest(uri, reqPayload);
            if (type.isArray()) {
                Map[] responseBody = (Map[])this.mapper.readValue(resp.body(), (TypeReference)new TypeReference<Map<String, Object>[]>(){});
                Optional<String> warrantToken = resp.headers().firstValue("warrant-token");
                for (Map map : responseBody) {
                    warrantToken.ifPresent(token -> map.put("warrantToken", token));
                }
                return (T)this.mapper.readValue(this.mapper.writeValueAsString((Object)responseBody), type);
            }
            Map responseBody = (Map)this.mapper.readValue(resp.body(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            Optional<String> warrantToken = resp.headers().firstValue("warrant-token");
            warrantToken.ifPresent(token -> responseBody.put("warrantToken", token));
            return (T)this.mapper.readValue(this.mapper.writeValueAsString((Object)responseBody), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    private HttpResponse<String> makePutRequest(String uri, Object reqPayload) throws WarrantException {
        return this.makePutRequest(uri, reqPayload, Collections.emptyMap());
    }

    private HttpResponse<String> makePutRequest(String uri, Object reqPayload, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> resp;
            int statusCode;
            String payload = this.mapper.writeValueAsString(reqPayload);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + uri)).PUT(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            for (Map.Entry<String, Object> requestOption : requestOptions.entrySet()) {
                requestBuilder.header(requestOption.getKey(), requestOption.getValue().toString());
            }
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (resp = this.makeRequestWithRetry(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    String makeDeleteRequest(String uri) throws WarrantException {
        return this.makeDeleteRequest(uri, null, Collections.emptyMap());
    }

    String makeDeleteRequest(String uri, Object reqPayload) throws WarrantException {
        return this.makeDeleteRequest(uri, reqPayload, Collections.emptyMap());
    }

    String makeDeleteRequest(String uri, Map<String, Object> requestOptions) throws WarrantException {
        return this.makeDeleteRequest(uri, null, requestOptions);
    }

    String makeDeleteRequest(String uri, Object reqPayload, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> httpResponse;
            int statusCode;
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + uri)).header("User-Agent", USER_AGENT);
            if (reqPayload != null) {
                String payload = this.mapper.writeValueAsString(reqPayload);
                requestBuilder.method("DELETE", HttpRequest.BodyPublishers.ofString(payload));
            } else {
                requestBuilder.DELETE();
            }
            for (Map.Entry entry : requestOptions.entrySet()) {
                requestBuilder.header((String)entry.getKey(), entry.getValue().toString());
            }
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (httpResponse = this.makeRequestWithRetry(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                Optional<String> warrantToken = httpResponse.headers().firstValue("warrant-token");
                if (warrantToken.isPresent()) {
                    return warrantToken.toString();
                }
                return "";
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + httpResponse.body());
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makeGetRequest(String uri, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makeGetRequest(uri, Collections.emptyMap());
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makeGetRequest(String uri, Map<String, Object> queryParams, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makeGetRequest(uri, queryParams);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makeGetRequest(String uri, Class<T> type, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makeGetRequest(uri, Collections.emptyMap(), requestOptions);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makeGetRequest(String uri, Map<String, Object> queryParams, Class<T> type, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makeGetRequest(uri, queryParams, requestOptions);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    private HttpResponse<String> makeGetRequest(String uri, Map<String, Object> queryParams) throws WarrantException {
        return this.makeGetRequest(uri, queryParams, Collections.emptyMap());
    }

    private HttpResponse<String> makeGetRequest(String uri, Map<String, Object> queryParams, Map<String, Object> requestOptions) throws WarrantException {
        HttpRequest httpRequest;
        HttpResponse<String> httpResponse;
        int statusCode;
        UriBuilder builder = UriBuilder.fromPath((String)(this.config.getBaseUrl() + uri));
        for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
            builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(builder.build(new Object[0])).GET().header("User-Agent", USER_AGENT);
        for (Map.Entry<String, Object> entry : requestOptions.entrySet()) {
            requestBuilder.header(entry.getKey(), entry.getValue().toString());
        }
        if (!this.config.getApiKey().isEmpty()) {
            requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
        }
        if ((statusCode = (httpResponse = this.makeRequestWithRetry(httpRequest = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
            return httpResponse;
        }
        throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + httpResponse.body());
    }

    static final Map<String, Object> getPaginationParams(int limit, int page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("limit", limit);
        params.put("page", page);
        return params;
    }

    private HttpResponse<String> makeRequestWithRetry(HttpRequest request, HttpResponse.BodyHandler<String> respBodyHandler) throws WarrantException {
        WarrantException requestException = null;
        HttpResponse<String> response = null;
        int retryAttempts = 0;
        while (true) {
            requestException = null;
            try {
                response = this.client.send(request, respBodyHandler);
            }
            catch (IOException | InterruptedException e) {
                requestException = new WarrantException(e);
            }
            if (!this.shouldRetryRequest(response, retryAttempts, requestException)) break;
            ++retryAttempts;
            try {
                Thread.sleep(this.getSleepTime(retryAttempts).toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (requestException != null) {
            throw requestException;
        }
        return response;
    }

    private boolean shouldRetryRequest(HttpResponse<String> response, int retryAttempts, WarrantException requestException) {
        if (retryAttempts > MAX_RETRIES) {
            return false;
        }
        if (requestException != null && requestException.getCause() != null && (requestException.getCause() instanceof ConnectException || requestException.getCause() instanceof SocketTimeoutException)) {
            return true;
        }
        if (requestException != null && requestException.getCause() != null && requestException.getCause() instanceof IOException && requestException.getMessage().contains("GOAWAY")) {
            return true;
        }
        return response != null && response.statusCode() == 502;
    }

    private Duration getSleepTime(int retryAttempt) {
        Duration sleepTime = Duration.ofNanos((long)((double)MINIMUM_SLEEP_TIME.toNanos() * Math.pow(BACKOFF_MULTIPLIER, retryAttempt + 1)));
        double jitter = ThreadLocalRandom.current().nextDouble(0.5, 1.5);
        sleepTime = Duration.ofNanos((long)((double)sleepTime.toNanos() * jitter));
        return sleepTime;
    }
}

