/*
 * Decompiled with CFR 0.152.
 */
package dev.warrant;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.warrant.ListParams;
import dev.warrant.RequestOptions;
import dev.warrant.WarrantConfig;
import dev.warrant.WarrantFilters;
import dev.warrant.exception.WarrantException;
import dev.warrant.model.UserSession;
import dev.warrant.model.UserSessionSpec;
import dev.warrant.model.Warrant;
import dev.warrant.model.WarrantCheck;
import dev.warrant.model.WarrantCheckSpec;
import dev.warrant.model.WarrantSpec;
import dev.warrant.model.WarrantSubject;
import dev.warrant.model.object.WarrantObject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WarrantBaseClient {
    public static final String SDK_VERSION = "3.5.0";
    public static final String USER_AGENT = "warrant-java/3.5.0";
    final HttpClient client;
    final WarrantConfig config;
    final ObjectMapper mapper;

    WarrantBaseClient(WarrantConfig config, HttpClient client) {
        this.config = config;
        this.client = client;
        this.mapper = new ObjectMapper();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public WarrantBaseClient(WarrantConfig config) {
        this(config, HttpClient.newHttpClient());
    }

    public Warrant createWarrant(WarrantObject object, String relation, WarrantSubject subject) throws WarrantException {
        return this.createWarrant(object, relation, subject, "", new RequestOptions());
    }

    public Warrant createWarrant(WarrantObject object, String relation, WarrantSubject subject, RequestOptions requestOptions) throws WarrantException {
        return this.createWarrant(object, relation, subject, "", requestOptions);
    }

    public Warrant createWarrant(WarrantObject object, String relation, WarrantSubject subject, String policy) throws WarrantException {
        return this.createWarrant(object, relation, subject, policy, new RequestOptions());
    }

    public Warrant createWarrant(WarrantObject object, String relation, WarrantSubject subject, String policy, RequestOptions requestOptions) throws WarrantException {
        Warrant toCreate = new Warrant(object.type(), object.id(), relation, subject, policy);
        return this.makePostRequest("/v1/warrants", toCreate, Warrant.class, requestOptions.asMap());
    }

    public void deleteWarrant(WarrantObject object, String relation, WarrantSubject subject) throws WarrantException {
        this.deleteWarrant(object, relation, subject, "", new RequestOptions());
    }

    public void deleteWarrant(WarrantObject object, String relation, WarrantSubject subject, RequestOptions requestOptions) throws WarrantException {
        this.deleteWarrant(object, relation, subject, "", requestOptions);
    }

    public void deleteWarrant(WarrantObject object, String relation, WarrantSubject subject, String policy) throws WarrantException {
        this.deleteWarrant(object, relation, subject, policy, new RequestOptions());
    }

    public void deleteWarrant(WarrantObject object, String relation, WarrantSubject subject, String policy, RequestOptions requestOptions) throws WarrantException {
        Warrant toDelete = new Warrant(object.type(), object.id(), relation, subject, policy);
        this.makeDeleteRequest("/v1/warrants", toDelete, requestOptions.asMap());
    }

    public Warrant[] listWarrants(WarrantFilters filters, ListParams listParams) throws WarrantException {
        return this.listWarrants(filters, listParams, new RequestOptions());
    }

    public Warrant[] listWarrants(WarrantFilters filters, ListParams listParams, RequestOptions requestOptions) throws WarrantException {
        Map<String, Object> queryParams = filters.asMap();
        queryParams.putAll(listParams.asMap());
        return this.makeGetRequest("/v1/warrants", queryParams, Warrant[].class, requestOptions.asMap());
    }

    public boolean check(WarrantObject object, String relation, WarrantSubject subject) throws WarrantException {
        return this.check(object, relation, subject, Collections.emptyMap(), new RequestOptions());
    }

    public boolean check(WarrantObject object, String relation, WarrantSubject subject, RequestOptions requestOptions) throws WarrantException {
        return this.check(object, relation, subject, Collections.emptyMap(), requestOptions);
    }

    public boolean check(WarrantObject object, String relation, WarrantSubject subject, Map<String, Object> context) throws WarrantException {
        return this.check(object, relation, subject, context, new RequestOptions());
    }

    public boolean check(WarrantObject object, String relation, WarrantSubject subject, Map<String, Object> context, RequestOptions requestOptions) throws WarrantException {
        WarrantCheckSpec toCheck = new WarrantCheckSpec(Arrays.asList(new WarrantSpec(object.type(), object.id(), relation, subject, context)));
        WarrantCheck result = this.makeCheckRequest(toCheck, requestOptions.asMap());
        return result.getCode() == 200 && "Authorized".equals(result.getResult());
    }

    public List<WarrantCheck> checkBatch(List<WarrantSpec> warrants) throws WarrantException {
        return this.checkBatch(warrants, new RequestOptions());
    }

    public List<WarrantCheck> checkBatch(List<WarrantSpec> warrants, RequestOptions requestOptions) throws WarrantException {
        WarrantCheck[] results = this.checkWithOp(warrants, "batch", WarrantCheck[].class, requestOptions);
        return Arrays.asList(results);
    }

    public WarrantCheck checkAnyOf(List<WarrantSpec> warrants) throws WarrantException {
        return this.checkAnyOf(warrants, new RequestOptions());
    }

    public WarrantCheck checkAnyOf(List<WarrantSpec> warrants, RequestOptions requestOptions) throws WarrantException {
        return this.checkWithOp(warrants, "anyOf", WarrantCheck.class, requestOptions);
    }

    public WarrantCheck checkAllOf(List<WarrantSpec> warrants) throws WarrantException {
        return this.checkAllOf(warrants, new RequestOptions());
    }

    public WarrantCheck checkAllOf(List<WarrantSpec> warrants, RequestOptions requestOptions) throws WarrantException {
        return this.checkWithOp(warrants, "allOf", WarrantCheck.class, new RequestOptions());
    }

    public void deleteObject(WarrantObject obj) throws WarrantException {
        this.deleteObject(obj.type(), obj.id());
    }

    public void deleteObject(String objectType, String objectId) throws WarrantException {
        this.makeDeleteRequest("/v1/objects/" + objectType + "/" + objectId);
    }

    public String createUserAuthzSession(String userId) throws WarrantException {
        return this.createUserAuthzSession(userId, new RequestOptions());
    }

    public String createUserAuthzSession(String userId, RequestOptions requestOptions) throws WarrantException {
        UserSession sess = this.makePostRequest("/v1/sessions", UserSessionSpec.newAuthorizationSessionSpec(userId), UserSession.class, requestOptions.asMap());
        return sess.getToken();
    }

    public String createUserSelfServiceDashboardUrl(String userId, String tenantId, String selfServiceStrategy, String redirectUrl) throws WarrantException {
        return this.createUserSelfServiceDashboardUrl(userId, tenantId, selfServiceStrategy, redirectUrl, new RequestOptions());
    }

    public String createUserSelfServiceDashboardUrl(String userId, String tenantId, String selfServiceStrategy, String redirectUrl, RequestOptions requestOptions) throws WarrantException {
        UserSession ssdash = this.makePostRequest("/v1/sessions", UserSessionSpec.newSelfServiceDashboardSessionSpec(userId, tenantId, selfServiceStrategy), UserSession.class, requestOptions.asMap());
        return this.config.getSelfServiceDashboardBaseUrl() + "/" + ssdash.getToken() + "?redirectUrl=" + redirectUrl;
    }

    WarrantCheck makeCheckRequest(WarrantCheckSpec toCheck) throws WarrantException {
        return this.makeCheckRequest(toCheck, Collections.emptyMap());
    }

    WarrantCheck makeCheckRequest(WarrantCheckSpec toCheck, Map<String, Object> requestOptions) throws WarrantException {
        try {
            String payload = this.mapper.writeValueAsString((Object)toCheck);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getCheckUrl() + "/v2/authorize")).POST(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            for (Map.Entry<String, Object> requestOption : requestOptions.entrySet()) {
                requestBuilder.header(requestOption.getKey(), requestOption.getValue().toString());
            }
            HttpRequest req = requestBuilder.build();
            HttpResponse<String> resp = this.client.send(req, HttpResponse.BodyHandlers.ofString());
            int statusCode = resp.statusCode();
            if (statusCode >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return (WarrantCheck)this.mapper.readValue(resp.body(), WarrantCheck.class);
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    <T> T checkWithOp(List<WarrantSpec> warrants, String op, Class<T> type, RequestOptions requestOptions) throws WarrantException {
        try {
            WarrantCheckSpec toCheck = new WarrantCheckSpec(warrants, op);
            String payload = this.mapper.writeValueAsString((Object)toCheck);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getCheckUrl() + "/v2/authorize")).POST(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            for (Map.Entry<String, Object> requestOption : requestOptions.asMap().entrySet()) {
                requestBuilder.header(requestOption.getKey(), requestOption.getValue().toString());
            }
            HttpRequest req = requestBuilder.build();
            HttpResponse<String> resp = this.client.send(req, HttpResponse.BodyHandlers.ofString());
            int statusCode = resp.statusCode();
            if (statusCode >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return (T)this.mapper.readValue(resp.body(), type);
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makePostRequest(String uri, Object reqPayload, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makePostRequest(uri, reqPayload);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makePostRequest(String uri, Object reqPayload, Class<T> type, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makePostRequest(uri, reqPayload, requestOptions);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    HttpResponse<String> makePostRequest(String uri, Object reqPayload) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> resp;
            int statusCode;
            String payload = this.mapper.writeValueAsString(reqPayload);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + uri)).POST(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (resp = this.client.send(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    HttpResponse<String> makePostRequest(String uri, Object reqPayload, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> resp;
            int statusCode;
            String payload = this.mapper.writeValueAsString(reqPayload);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + uri)).POST(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            for (Map.Entry<String, Object> requestOption : requestOptions.entrySet()) {
                requestBuilder.header(requestOption.getKey(), requestOption.getValue().toString());
            }
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (resp = this.client.send(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makePutRequest(String uri, Object reqPayload, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makePutRequest(uri, reqPayload);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makePutRequest(String uri, Object reqPayload, Class<T> type, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makePutRequest(uri, reqPayload, requestOptions);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    private HttpResponse<String> makePutRequest(String uri, Object reqPayload) throws WarrantException {
        return this.makePutRequest(uri, reqPayload, Collections.emptyMap());
    }

    private HttpResponse<String> makePutRequest(String uri, Object reqPayload, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> resp;
            int statusCode;
            String payload = this.mapper.writeValueAsString(reqPayload);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + uri)).PUT(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            for (Map.Entry<String, Object> requestOption : requestOptions.entrySet()) {
                requestBuilder.header(requestOption.getKey(), requestOption.getValue().toString());
            }
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (resp = this.client.send(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    HttpResponse<String> makeDeleteRequest(String uri) throws WarrantException {
        return this.makeDeleteRequest(uri, null, Collections.emptyMap());
    }

    HttpResponse<String> makeDeleteRequest(String uri, Object reqPayload) throws WarrantException {
        return this.makeDeleteRequest(uri, reqPayload, Collections.emptyMap());
    }

    HttpResponse<String> makeDeleteRequest(String uri, Map<String, Object> requestOptions) throws WarrantException {
        return this.makeDeleteRequest(uri, null, requestOptions);
    }

    HttpResponse<String> makeDeleteRequest(String uri, Object reqPayload, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> httpResponse;
            int statusCode;
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + uri)).header("User-Agent", USER_AGENT);
            if (reqPayload != null) {
                String payload = this.mapper.writeValueAsString(reqPayload);
                requestBuilder.method("DELETE", HttpRequest.BodyPublishers.ofString(payload));
            } else {
                requestBuilder.DELETE();
            }
            for (Map.Entry entry : requestOptions.entrySet()) {
                requestBuilder.header((String)entry.getKey(), entry.getValue().toString());
            }
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (httpResponse = this.client.send(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return httpResponse;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + httpResponse.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makeGetRequest(String uri, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makeGetRequest(uri, Collections.emptyMap());
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makeGetRequest(String uri, Map<String, Object> queryParams, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makeGetRequest(uri, queryParams);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makeGetRequest(String uri, Class<T> type, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makeGetRequest(uri, Collections.emptyMap(), requestOptions);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makeGetRequest(String uri, Map<String, Object> queryParams, Class<T> type, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makeGetRequest(uri, queryParams, requestOptions);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    private HttpResponse<String> makeGetRequest(String uri, Map<String, Object> queryParams) throws WarrantException {
        return this.makeGetRequest(uri, queryParams, Collections.emptyMap());
    }

    private HttpResponse<String> makeGetRequest(String uri, Map<String, Object> queryParams, Map<String, Object> requestOptions) throws WarrantException {
        try {
            HttpRequest httpRequest;
            HttpResponse<String> httpResponse;
            int statusCode;
            UriBuilder builder = UriBuilder.fromPath((String)(this.config.getBaseUrl() + uri));
            for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(builder.build(new Object[0])).GET().header("User-Agent", USER_AGENT);
            for (Map.Entry<String, Object> entry : requestOptions.entrySet()) {
                requestBuilder.header(entry.getKey(), entry.getValue().toString());
            }
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (httpResponse = this.client.send(httpRequest = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return httpResponse;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + httpResponse.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    static final Map<String, Object> getPaginationParams(int limit, int page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("limit", limit);
        params.put("page", page);
        return params;
    }
}

