/*
 * Decompiled with CFR 0.152.
 */
package dev.warrant;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.warrant.Query;
import dev.warrant.WarrantConfig;
import dev.warrant.exception.WarrantException;
import dev.warrant.model.UserSession;
import dev.warrant.model.UserSessionSpec;
import dev.warrant.model.Warrant;
import dev.warrant.model.WarrantCheck;
import dev.warrant.model.WarrantCheckSpec;
import dev.warrant.model.WarrantSpec;
import dev.warrant.model.WarrantSubject;
import dev.warrant.model.object.WarrantObject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class WarrantBaseClient {
    public static final String SDK_VERSION = "3.1.0";
    public static final String USER_AGENT = "warrant-java/3.1.0";
    final HttpClient client;
    final WarrantConfig config;
    final ObjectMapper mapper;

    WarrantBaseClient(WarrantConfig config, HttpClient client) {
        this.config = config;
        this.client = client;
        this.mapper = new ObjectMapper();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public WarrantBaseClient(WarrantConfig config) {
        this(config, HttpClient.newHttpClient());
    }

    public Warrant createWarrant(WarrantObject object, String relation, WarrantSubject subject) throws WarrantException {
        Warrant toCreate = new Warrant(object.type(), object.id(), relation, subject);
        return this.makePostRequest("/v1/warrants", toCreate, Warrant.class);
    }

    public Warrant createWarrant(WarrantObject object, String relation, WarrantSubject subject, String policy) throws WarrantException {
        Warrant toCreate = new Warrant(object.type(), object.id(), relation, subject, policy);
        return this.makePostRequest("/v1/warrants", toCreate, Warrant.class);
    }

    public void deleteWarrant(WarrantObject object, String relation, WarrantSubject subject) throws WarrantException {
        try {
            Warrant toDelete = new Warrant(object.type(), object.id(), relation, subject);
            String payload = this.mapper.writeValueAsString((Object)toDelete);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + "/v1/warrants")).method("DELETE", HttpRequest.BodyPublishers.ofString(payload)).header("Authorization", "ApiKey " + this.config.getApiKey()).header("User-Agent", USER_AGENT).build();
            HttpResponse<String> resp = this.client.send(req, HttpResponse.BodyHandlers.ofString());
            int statusCode = resp.statusCode();
            if (statusCode != Response.Status.OK.getStatusCode()) {
                throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    public void deleteWarrant(WarrantObject object, String relation, WarrantSubject subject, String policy) throws WarrantException {
        try {
            Warrant toDelete = new Warrant(object.type(), object.id(), relation, subject, policy);
            String payload = this.mapper.writeValueAsString((Object)toDelete);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + "/v1/warrants")).method("DELETE", HttpRequest.BodyPublishers.ofString(payload)).header("Authorization", "ApiKey " + this.config.getApiKey()).header("User-Agent", USER_AGENT).build();
            HttpResponse<String> resp = this.client.send(req, HttpResponse.BodyHandlers.ofString());
            int statusCode = resp.statusCode();
            if (statusCode != Response.Status.OK.getStatusCode()) {
                throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    public Warrant[] queryWarrants(Query query, int limit, int page) throws WarrantException {
        Map<String, Object> queryParams = query.asMap();
        queryParams.put("limit", limit);
        queryParams.put("page", page);
        return this.makeGetRequest("/v1/query", queryParams, Warrant[].class);
    }

    public boolean check(WarrantObject object, String relation, WarrantSubject subject) throws WarrantException {
        WarrantCheckSpec toCheck = new WarrantCheckSpec(Arrays.asList(new WarrantSpec(object.type(), object.id(), relation, subject)));
        WarrantCheck result = this.makeCheckRequest(toCheck);
        return result.getCode() == 200 && "Authorized".equals(result.getResult());
    }

    public boolean check(WarrantObject object, String relation, WarrantSubject subject, Map<String, Object> context) throws WarrantException {
        WarrantCheckSpec toCheck = new WarrantCheckSpec(Arrays.asList(new WarrantSpec(object.type(), object.id(), relation, subject, context)));
        WarrantCheck result = this.makeCheckRequest(toCheck);
        return result.getCode() == 200 && "Authorized".equals(result.getResult());
    }

    public String createUserAuthzSession(String userId) throws WarrantException {
        UserSession sess = this.makePostRequest("/v1/sessions", UserSessionSpec.newAuthorizationSessionSpec(userId), UserSession.class);
        return sess.getToken();
    }

    public String createUserSelfServiceDashboardUrl(String userId, String tenantId, String selfServiceStrategy, String redirectUrl) throws WarrantException {
        UserSession ssdash = this.makePostRequest("/v1/sessions", UserSessionSpec.newSelfServiceDashboardSessionSpec(userId, tenantId, selfServiceStrategy), UserSession.class);
        return this.config.getSelfServiceDashboardBaseUrl() + "/" + ssdash.getToken() + "?redirectUrl=" + redirectUrl;
    }

    WarrantCheck makeCheckRequest(WarrantCheckSpec toCheck) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> resp;
            int statusCode;
            String payload = this.mapper.writeValueAsString((Object)toCheck);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getCheckUrl() + "/v2/authorize")).POST(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (resp = this.client.send(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return (WarrantCheck)this.mapper.readValue(resp.body(), WarrantCheck.class);
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makePostRequest(String uri, Object reqPayload, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makePostRequest(uri, reqPayload);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    HttpResponse<String> makePostRequest(String uri, Object reqPayload) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> resp;
            int statusCode;
            String payload = this.mapper.writeValueAsString(reqPayload);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + uri)).POST(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (resp = this.client.send(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makePutRequest(String uri, Object reqPayload, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makePutRequest(uri, reqPayload);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    private HttpResponse<String> makePutRequest(String uri, Object reqPayload) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> resp;
            int statusCode;
            String payload = this.mapper.writeValueAsString(reqPayload);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + uri)).PUT(HttpRequest.BodyPublishers.ofString(payload)).header("User-Agent", USER_AGENT);
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (resp = this.client.send(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    HttpResponse<String> makeDeleteRequest(String uri) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> resp;
            int statusCode;
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.config.getBaseUrl() + uri)).DELETE().header("User-Agent", USER_AGENT);
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (resp = this.client.send(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makeGetRequest(String uri, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makeGetRequest(uri, Collections.EMPTY_MAP);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    <T> T makeGetRequest(String uri, Map<String, Object> queryParams, Class<T> type) throws WarrantException {
        try {
            HttpResponse<String> resp = this.makeGetRequest(uri, queryParams);
            return (T)this.mapper.readValue(resp.body(), type);
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    private HttpResponse<String> makeGetRequest(String uri, Map<String, Object> queryParams) throws WarrantException {
        try {
            HttpRequest req;
            HttpResponse<String> resp;
            int statusCode;
            UriBuilder builder = UriBuilder.fromPath((String)(this.config.getBaseUrl() + uri));
            for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(builder.build(new Object[0])).GET().header("User-Agent", USER_AGENT);
            if (!this.config.getApiKey().isEmpty()) {
                requestBuilder.header("Authorization", "ApiKey " + this.config.getApiKey());
            }
            if ((statusCode = (resp = this.client.send(req = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= Response.Status.OK.getStatusCode() && statusCode < 300) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    static final Map<String, Object> getPaginationParams(int limit, int page) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("limit", limit);
        params.put("page", page);
        return params;
    }
}

