/*
 * Decompiled with CFR 0.152.
 */
package dev.warrant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Query {
    private final String selectClause;
    private final List<String> forClauses;
    private final List<String> whereClauses;

    public static Query selectWarrants() {
        return new Query("warrants");
    }

    public static Query selectExplicitWarrants() {
        return new Query("explicit warrants");
    }

    private Query(String select) {
        this.selectClause = select;
        this.forClauses = new ArrayList<String>();
        this.whereClauses = new ArrayList<String>();
    }

    public Query forClause(String forClause) {
        this.forClauses.add(forClause);
        return this;
    }

    public Query where(String where) {
        this.whereClauses.add(where);
        return this;
    }

    public Map<String, Object> asMap() {
        StringBuilder b;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("select", this.selectClause);
        if (this.forClauses.size() > 0) {
            b = new StringBuilder();
            for (String f : this.forClauses) {
                b.append(f).append(",");
            }
            b.delete(b.length() - 1, b.length());
            params.put("for", b.toString());
        }
        if (this.whereClauses.size() > 0) {
            b = new StringBuilder();
            for (String f : this.whereClauses) {
                b.append(f).append(",");
            }
            b.delete(b.length() - 1, b.length());
            params.put("where", b.toString());
        }
        return params;
    }
}

