/*
 * Decompiled with CFR 0.152.
 */
package dev.warrant;

import dev.warrant.WarrantBaseClient;
import dev.warrant.WarrantConfig;
import dev.warrant.exception.WarrantException;
import dev.warrant.model.WarrantSubject;
import dev.warrant.model.object.Feature;
import dev.warrant.model.object.Permission;
import dev.warrant.model.object.PricingTier;
import dev.warrant.model.object.Role;
import dev.warrant.model.object.Tenant;
import dev.warrant.model.object.User;
import java.net.http.HttpClient;
import java.util.Collections;

public class WarrantClient
extends WarrantBaseClient {
    WarrantClient(WarrantConfig config, HttpClient client) {
        super(config, client);
    }

    public WarrantClient(WarrantConfig config) {
        super(config);
    }

    public User createUser() throws WarrantException {
        return this.makePostRequest("/v1/users", Collections.EMPTY_MAP, User.class);
    }

    public User createUser(User user) throws WarrantException {
        return this.makePostRequest("/v1/users", user, User.class);
    }

    public User[] createUsers(User[] users) throws WarrantException {
        return this.makePostRequest("/v1/users", users, User[].class);
    }

    public User updateUser(String userId, User toUpdate) throws WarrantException {
        return this.makePutRequest("/v1/users/" + userId, toUpdate, User.class);
    }

    public void deleteUser(User user) throws WarrantException {
        this.deleteUser(user.getUserId());
    }

    public void deleteUser(String userId) throws WarrantException {
        this.makeDeleteRequest("/v1/users/" + userId);
    }

    public User getUser(String userId) throws WarrantException {
        return this.makeGetRequest("/v1/users/" + userId, User.class);
    }

    public User[] listUsers(int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/users", WarrantClient.getPaginationParams(limit, page), User[].class);
    }

    public User[] listUsersForTenant(Tenant tenant, int limit, int page) throws WarrantException {
        return this.listUsersForTenant(tenant.getTenantId(), limit, page);
    }

    public User[] listUsersForTenant(String tenantId, int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/tenants/" + tenantId + "/users", WarrantClient.getPaginationParams(limit, page), User[].class);
    }

    public Tenant createTenant() throws WarrantException {
        return this.makePostRequest("/v1/tenants", Collections.EMPTY_MAP, Tenant.class);
    }

    public Tenant createTenant(Tenant tenant) throws WarrantException {
        return this.makePostRequest("/v1/tenants", tenant, Tenant.class);
    }

    public Tenant[] createTenants(Tenant[] tenants) throws WarrantException {
        return this.makePostRequest("/v1/tenants", tenants, Tenant[].class);
    }

    public Tenant updateTenant(String tenantId, Tenant toUpdate) throws WarrantException {
        return this.makePutRequest("/v1/tenants/" + tenantId, toUpdate, Tenant.class);
    }

    public void deleteTenant(Tenant tenant) throws WarrantException {
        this.deleteTenant(tenant.getTenantId());
    }

    public void deleteTenant(String tenantId) throws WarrantException {
        this.makeDeleteRequest("/v1/tenants/" + tenantId);
    }

    public Tenant getTenant(String tenantId) throws WarrantException {
        return this.makeGetRequest("/v1/tenants/" + tenantId, Tenant.class);
    }

    public Tenant[] listTenants(int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/tenants", WarrantClient.getPaginationParams(limit, page), Tenant[].class);
    }

    public Tenant[] listTenantsForUser(User user, int limit, int page) throws WarrantException {
        return this.listTenantsForUser(user.getUserId(), limit, page);
    }

    public Tenant[] listTenantsForUser(String userId, int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/users/" + userId + "/tenants", WarrantClient.getPaginationParams(limit, page), Tenant[].class);
    }

    public Role createRole(Role role) throws WarrantException {
        return this.makePostRequest("/v1/roles", role, Role.class);
    }

    public Role updateRole(String roleId, Role toUpdate) throws WarrantException {
        return this.makePutRequest("/v1/roles/" + roleId, toUpdate, Role.class);
    }

    public void deleteRole(Role role) throws WarrantException {
        this.deleteRole(role.getRoleId());
    }

    public void deleteRole(String roleId) throws WarrantException {
        this.makeDeleteRequest("/v1/roles/" + roleId);
    }

    public Role getRole(String roleId) throws WarrantException {
        return this.makeGetRequest("/v1/roles/" + roleId, Role.class);
    }

    public Role[] listRoles(int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/roles", WarrantClient.getPaginationParams(limit, page), Role[].class);
    }

    public Role[] listRolesForUser(User user, int limit, int page) throws WarrantException {
        return this.listRolesForUser(user.getUserId(), limit, page);
    }

    public Role[] listRolesForUser(String userId, int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/users/" + userId + "/roles", WarrantClient.getPaginationParams(limit, page), Role[].class);
    }

    public Permission createPermission(Permission permission) throws WarrantException {
        return this.makePostRequest("/v1/permissions", permission, Permission.class);
    }

    public Permission updatePermission(String permissionId, Permission toUpdate) throws WarrantException {
        return this.makePutRequest("/v1/permissions/" + permissionId, toUpdate, Permission.class);
    }

    public void deletePermission(Permission permission) throws WarrantException {
        this.deletePermission(permission.getPermissionId());
    }

    public void deletePermission(String permissionId) throws WarrantException {
        this.makeDeleteRequest("/v1/permissions/" + permissionId);
    }

    public Permission getPermission(String permissionId) throws WarrantException {
        return this.makeGetRequest("/v1/permissions/" + permissionId, Permission.class);
    }

    public Permission[] listPermissions(int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/permissions", WarrantClient.getPaginationParams(limit, page), Permission[].class);
    }

    public Permission[] listPermissionsForUser(User user, int limit, int page) throws WarrantException {
        return this.listPermissionsForUser(user.getUserId(), limit, page);
    }

    public Permission[] listPermissionsForUser(String userId, int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/users/" + userId + "/permissions", WarrantClient.getPaginationParams(limit, page), Permission[].class);
    }

    public Permission[] listPermissionsForRole(Role role, int limit, int page) throws WarrantException {
        return this.listPermissionsForRole(role.getRoleId(), limit, page);
    }

    public Permission[] listPermissionsForRole(String roleId, int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/roles/" + roleId + "/permissions", WarrantClient.getPaginationParams(limit, page), Permission[].class);
    }

    public Feature createFeature(Feature feature) throws WarrantException {
        return this.makePostRequest("/v1/features", feature, Feature.class);
    }

    public void deleteFeature(Feature feature) throws WarrantException {
        this.deleteFeature(feature.getFeatureId());
    }

    public void deleteFeature(String featureId) throws WarrantException {
        this.makeDeleteRequest("/v1/features/" + featureId);
    }

    public Feature getFeature(String featureId) throws WarrantException {
        return this.makeGetRequest("/v1/features/" + featureId, Feature.class);
    }

    public Feature[] listFeatures(int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/features", WarrantClient.getPaginationParams(limit, page), Feature[].class);
    }

    public Feature[] listFeaturesForUser(User user, int limit, int page) throws WarrantException {
        return this.listFeaturesForUser(user.getUserId(), limit, page);
    }

    public Feature[] listFeaturesForUser(String userId, int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/users/" + userId + "/features", WarrantClient.getPaginationParams(limit, page), Feature[].class);
    }

    public Feature[] listFeaturesForTenant(Tenant tenant, int limit, int page) throws WarrantException {
        return this.listFeaturesForTenant(tenant.getTenantId(), limit, page);
    }

    public Feature[] listFeaturesForTenant(String tenantId, int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/tenants/" + tenantId + "/features", WarrantClient.getPaginationParams(limit, page), Feature[].class);
    }

    public Feature[] listFeaturesForPricingTier(PricingTier pricingTier, int limit, int page) throws WarrantException {
        return this.listFeaturesForPricingTier(pricingTier.getPricingTierId(), limit, page);
    }

    public Feature[] listFeaturesForPricingTier(String pricingTierId, int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/pricing-tiers/" + pricingTierId + "/features", WarrantClient.getPaginationParams(limit, page), Feature[].class);
    }

    public PricingTier createPricingTier(PricingTier pricingTier) throws WarrantException {
        return this.makePostRequest("/v1/pricing-tiers", pricingTier, PricingTier.class);
    }

    public void deletePricingTier(PricingTier pricingTier) throws WarrantException {
        this.deletePricingTier(pricingTier.getPricingTierId());
    }

    public void deletePricingTier(String pricingTierId) throws WarrantException {
        this.makeDeleteRequest("/v1/pricing-tiers/" + pricingTierId);
    }

    public PricingTier getPricingTier(String pricingTierId) throws WarrantException {
        return this.makeGetRequest("/v1/pricing-tiers/" + pricingTierId, PricingTier.class);
    }

    public PricingTier[] listPricingTiers(int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/pricing-tiers", WarrantClient.getPaginationParams(limit, page), PricingTier[].class);
    }

    public PricingTier[] listPricingTiersForTenant(Tenant tenant, int limit, int page) throws WarrantException {
        return this.listPricingTiersForTenant(tenant.getTenantId(), limit, page);
    }

    public PricingTier[] listPricingTiersForTenant(String tenantId, int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/tenants/" + tenantId + "/pricing-tiers", WarrantClient.getPaginationParams(limit, page), PricingTier[].class);
    }

    public PricingTier[] listPricingTiersForUser(User user, int limit, int page) throws WarrantException {
        return this.listPricingTiersForUser(user.getUserId(), limit, page);
    }

    public PricingTier[] listPricingTiersForUser(String userId, int limit, int page) throws WarrantException {
        return this.makeGetRequest("/v1/users/" + userId + "/pricing-tiers", WarrantClient.getPaginationParams(limit, page), PricingTier[].class);
    }

    public void assignRoleToUser(Role role, User user) throws WarrantException {
        this.assignRoleToUser(role.getRoleId(), user.getUserId());
    }

    public void assignRoleToUser(String roleId, String userId) throws WarrantException {
        this.makePostRequest("/v1/users/" + userId + "/roles/" + roleId, Collections.EMPTY_MAP);
    }

    public void assignPermissionToUser(Permission permission, User user) throws WarrantException {
        this.assignPermissionToUser(permission.getPermissionId(), user.getUserId());
    }

    public void assignPermissionToUser(String permissionId, String userId) throws WarrantException {
        this.makePostRequest("/v1/users/" + userId + "/permissions/" + permissionId, Collections.EMPTY_MAP);
    }

    public void assignPricingTierToUser(PricingTier pricingTier, User user) throws WarrantException {
        this.assignPricingTierToUser(pricingTier.getPricingTierId(), user.getUserId());
    }

    public void assignPricingTierToUser(String pricingTierId, String userId) throws WarrantException {
        this.makePostRequest("/v1/users/" + userId + "/pricing-tiers/" + pricingTierId, Collections.EMPTY_MAP);
    }

    public void assignFeatureToUser(Feature feature, User user) throws WarrantException {
        this.assignFeatureToUser(feature.getFeatureId(), user.getUserId());
    }

    public void assignFeatureToUser(String featureId, String userId) throws WarrantException {
        this.makePostRequest("/v1/users/" + userId + "/features/" + featureId, Collections.EMPTY_MAP);
    }

    public void assignUserToTenant(User user, Tenant tenant) throws WarrantException {
        this.assignUserToTenant(user.getUserId(), tenant.getTenantId());
    }

    public void assignUserToTenant(String userId, String tenantId) throws WarrantException {
        this.makePostRequest("/v1/tenants/" + tenantId + "/users/" + userId, Collections.EMPTY_MAP);
    }

    public void assignPricingTierToTenant(PricingTier pricingTier, Tenant tenant) throws WarrantException {
        this.assignPricingTierToTenant(pricingTier.getPricingTierId(), tenant.getTenantId());
    }

    public void assignPricingTierToTenant(String pricingTierId, String tenantId) throws WarrantException {
        this.makePostRequest("/v1/tenants/" + tenantId + "/pricing-tiers/" + pricingTierId, Collections.EMPTY_MAP);
    }

    public void assignFeatureToTenant(Feature feature, Tenant tenant) throws WarrantException {
        this.assignFeatureToTenant(feature.getFeatureId(), tenant.getTenantId());
    }

    public void assignFeatureToTenant(String featureId, String tenantId) throws WarrantException {
        this.makePostRequest("/v1/tenants/" + tenantId + "/features/" + featureId, Collections.EMPTY_MAP);
    }

    public void assignFeatureToPricingTier(Feature feature, PricingTier pricingTier) throws WarrantException {
        this.assignFeatureToPricingTier(feature.getFeatureId(), pricingTier.getPricingTierId());
    }

    public void assignFeatureToPricingTier(String featureId, String pricingTierId) throws WarrantException {
        this.makePostRequest("/v1/pricing-tiers/" + pricingTierId + "/features/" + featureId, Collections.EMPTY_MAP);
    }

    public void assignPermissionToRole(Permission permission, Role role) throws WarrantException {
        this.assignPermissionToRole(permission.getPermissionId(), role.getRoleId());
    }

    public void assignPermissionToRole(String permissionId, String roleId) throws WarrantException {
        this.makePostRequest("/v1/roles/" + roleId + "/permissions/" + permissionId, Collections.EMPTY_MAP);
    }

    public void removeRoleFromUser(Role role, User user) throws WarrantException {
        this.removeRoleFromUser(role.getRoleId(), user.getUserId());
    }

    public void removeRoleFromUser(String roleId, String userId) throws WarrantException {
        this.makeDeleteRequest("/v1/users/" + userId + "/roles/" + roleId);
    }

    public void removePermissionFromUser(Permission permission, User user) throws WarrantException {
        this.removePermissionFromUser(permission.getPermissionId(), user.getUserId());
    }

    public void removePermissionFromUser(String permissionId, String userId) throws WarrantException {
        this.makeDeleteRequest("/v1/users/" + userId + "/permissions/" + permissionId);
    }

    public void removePricingTierFromUser(PricingTier pricingTier, User user) throws WarrantException {
        this.removePricingTierFromUser(pricingTier.getPricingTierId(), user.getUserId());
    }

    public void removePricingTierFromUser(String pricingTierId, String userId) throws WarrantException {
        this.makeDeleteRequest("/v1/users/" + userId + "/pricing-tiers/" + pricingTierId);
    }

    public void removeFeatureFromUser(Feature feature, User user) throws WarrantException {
        this.removeFeatureFromUser(feature.getFeatureId(), user.getUserId());
    }

    public void removeFeatureFromUser(String featureId, String userId) throws WarrantException {
        this.makeDeleteRequest("/v1/users/" + userId + "/features/" + featureId);
    }

    public void removeUserFromTenant(User user, Tenant tenant) throws WarrantException {
        this.removeUserFromTenant(user.getUserId(), tenant.getTenantId());
    }

    public void removeUserFromTenant(String userId, String tenantId) throws WarrantException {
        this.makeDeleteRequest("/v1/tenants/" + tenantId + "/users/" + userId);
    }

    public void removePricingTierFromTenant(PricingTier pricingTier, Tenant tenant) throws WarrantException {
        this.removePricingTierFromTenant(pricingTier.getPricingTierId(), tenant.getTenantId());
    }

    public void removePricingTierFromTenant(String pricingTierId, String tenantId) throws WarrantException {
        this.makeDeleteRequest("/v1/tenants/" + tenantId + "/pricing-tiers/" + pricingTierId);
    }

    public void removeFeatureFromTenant(Feature feature, Tenant tenant) throws WarrantException {
        this.removeFeatureFromTenant(feature.getFeatureId(), tenant.getTenantId());
    }

    public void removeFeatureFromTenant(String featureId, String tenantId) throws WarrantException {
        this.makeDeleteRequest("/v1/tenants/" + tenantId + "/features/" + featureId);
    }

    public void removeFeatureFromPricingTier(Feature feature, PricingTier pricingTier) throws WarrantException {
        this.removeFeatureFromPricingTier(feature.getFeatureId(), pricingTier.getPricingTierId());
    }

    public void removeFeatureFromPricingTier(String featureId, String pricingTierId) throws WarrantException {
        this.makeDeleteRequest("/v1/pricing-tiers/" + pricingTierId + "/features/" + featureId);
    }

    public void removePermissionFromRole(Permission permission, Role role) throws WarrantException {
        this.removePermissionFromRole(permission.getPermissionId(), role.getRoleId());
    }

    public void removePermissionFromRole(String permissionId, String roleId) throws WarrantException {
        this.makeDeleteRequest("/v1/roles/" + roleId + "/permissions/" + permissionId);
    }

    public boolean checkUserHasPermission(User user, String permissionId) throws WarrantException {
        return this.checkUserHasPermission(user.getUserId(), permissionId);
    }

    public boolean checkUserHasPermission(String userId, String permissionId) throws WarrantException {
        Permission perm = new Permission();
        perm.setPermissionId(permissionId);
        WarrantSubject subject = new WarrantSubject("user", userId);
        return this.check(perm, "member", subject);
    }

    public boolean checkTenantHasFeature(Tenant tenant, String featureId) throws WarrantException {
        return this.checkTenantHasFeature(tenant.getTenantId(), featureId);
    }

    public boolean checkTenantHasFeature(String tenantId, String featureId) throws WarrantException {
        Feature feature = new Feature();
        feature.setFeatureId(featureId);
        WarrantSubject subject = new WarrantSubject("tenant", tenantId);
        return this.check(feature, "member", subject);
    }

    public boolean checkUserHasFeature(User user, String featureId) throws WarrantException {
        return this.checkUserHasFeature(user.getUserId(), featureId);
    }

    public boolean checkUserHasFeature(String userId, String featureId) throws WarrantException {
        Feature feature = new Feature();
        feature.setFeatureId(featureId);
        WarrantSubject subject = new WarrantSubject("user", userId);
        return this.check(feature, "member", subject);
    }
}

