/*
 * Decompiled with CFR 0.152.
 */
package dev.warrant;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.warrant.WarrantConfig;
import dev.warrant.exception.WarrantException;
import dev.warrant.model.Tenant;
import dev.warrant.model.User;
import dev.warrant.model.UsersetWarrant;
import dev.warrant.model.Warrant;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class WarrantClient {
    private final HttpClient client = HttpClient.newHttpClient();
    private final WarrantConfig config;
    private final ObjectMapper mapper;

    public WarrantClient(WarrantConfig config) {
        this.config = config;
        this.mapper = new ObjectMapper();
    }

    public User createUser() throws WarrantException {
        HttpResponse<String> resp = this.makePostRequest("/users", Collections.EMPTY_MAP);
        try {
            User newUser = (User)this.mapper.readValue(resp.body(), User.class);
            return newUser;
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    public User createUser(String userId) throws WarrantException {
        User user = new User(userId);
        HttpResponse<String> resp = this.makePostRequest("/users", user);
        try {
            User newUser = (User)this.mapper.readValue(resp.body(), User.class);
            return newUser;
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    public User createUser(String userId, String email) throws WarrantException {
        User user = new User(userId, email);
        HttpResponse<String> resp = this.makePostRequest("/users", user);
        try {
            User newUser = (User)this.mapper.readValue(resp.body(), User.class);
            return newUser;
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    public Tenant createTenant() throws WarrantException {
        HttpResponse<String> resp = this.makePostRequest("/tenants", Collections.EMPTY_MAP);
        try {
            Tenant newTenant = (Tenant)this.mapper.readValue(resp.body(), Tenant.class);
            return newTenant;
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    public Tenant createTenant(String tenantId) throws WarrantException {
        Tenant tenant = new Tenant(tenantId);
        HttpResponse<String> resp = this.makePostRequest("/tenants", tenant);
        try {
            Tenant newTenant = (Tenant)this.mapper.readValue(resp.body(), Tenant.class);
            return newTenant;
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    public boolean isAuthorized(Warrant toCheck) throws WarrantException {
        HttpResponse<String> resp = this.makePostRequest("/authorize", toCheck);
        return resp.statusCode() == Response.Status.OK.getStatusCode();
    }

    public void createWarrant(Warrant toCreate) throws WarrantException {
        HttpResponse<String> resp = this.makePostRequest("/warrants", toCreate);
        if (resp.statusCode() != Response.Status.OK.getStatusCode()) {
            throw new WarrantException("Warrant request failed: HTTP " + resp.statusCode() + " " + resp.body());
        }
    }

    public UsersetWarrant[] listWarrants(Map<String, Object> filters) throws WarrantException {
        HttpResponse<String> resp = this.makeGetRequest("/warrants", filters);
        try {
            UsersetWarrant[] warrants = (UsersetWarrant[])this.mapper.readValue(resp.body(), UsersetWarrant[].class);
            return warrants;
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    public String createSession(String userId) throws WarrantException {
        HttpResponse<String> resp = this.makePostRequest("/users/" + userId + "/sessions", Collections.EMPTY_MAP);
        try {
            JsonNode respBody = this.mapper.readTree(resp.body());
            return respBody.get("token").asText();
        }
        catch (IOException e) {
            throw new WarrantException(e);
        }
    }

    private HttpResponse<String> makePostRequest(String uri, Object reqPayload) throws WarrantException {
        try {
            String payload = this.mapper.writeValueAsString(reqPayload);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.config.getUrl() + uri)).POST(HttpRequest.BodyPublishers.ofString(payload)).header("Authorization", "ApiKey " + this.config.getApiKey()).build();
            HttpResponse<String> resp = this.client.send(req, HttpResponse.BodyHandlers.ofString());
            int statusCode = resp.statusCode();
            if (statusCode >= Response.Status.OK.getStatusCode() && statusCode < Response.Status.BAD_REQUEST.getStatusCode() || statusCode == Response.Status.UNAUTHORIZED.getStatusCode()) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }

    private HttpResponse<String> makeGetRequest(String uri, Map<String, Object> params) throws WarrantException {
        try {
            UriBuilder builder = UriBuilder.fromPath((String)(this.config.getUrl() + uri));
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
            HttpRequest req = HttpRequest.newBuilder().uri(builder.build(new Object[0])).GET().header("Authorization", "ApiKey " + this.config.getApiKey()).build();
            HttpResponse<String> resp = this.client.send(req, HttpResponse.BodyHandlers.ofString());
            int statusCode = resp.statusCode();
            if (statusCode >= Response.Status.OK.getStatusCode() && statusCode < Response.Status.BAD_REQUEST.getStatusCode() || statusCode == Response.Status.UNAUTHORIZED.getStatusCode()) {
                return resp;
            }
            throw new WarrantException("Warrant request failed: HTTP " + statusCode + " " + resp.body());
        }
        catch (IOException | InterruptedException e) {
            throw new WarrantException(e);
        }
    }
}

