/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dynamicproxy.processor;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.ModifierVisitor;
import com.github.javaparser.ast.visitor.Visitable;
import com.github.javaparser.printer.Printer;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ClassLoaderTypeSolver;
import com.sun.source.util.Trees;
import dev.vankka.dynamicproxy.DynamicProxy;
import dev.vankka.dynamicproxy.processor.Original;
import dev.vankka.dynamicproxy.processor.Proxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"dev.vankka.dynamicproxy.processor.Proxy"})
public class DynamicProxyProcessor
extends AbstractProcessor {
    private static final String DYNAMIC_PROXY_CLASS_NAME = DynamicProxy.class.getName();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion maximumVersion;
        SourceVersion version = SourceVersion.latestSupported();
        SourceVersion minimumVersion = SourceVersion.RELEASE_8;
        try {
            maximumVersion = SourceVersion.valueOf("RELEASE_21");
        }
        catch (IllegalArgumentException ignored) {
            maximumVersion = SourceVersion.latestSupported();
        }
        if (version.ordinal() < minimumVersion.ordinal()) {
            return minimumVersion;
        }
        if (version.ordinal() > maximumVersion.ordinal()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, this.getClass().getName() + " only supports parsing of Java features up-to " + (Object)((Object)maximumVersion) + " which is less than the current " + (Object)((Object)version));
            return version;
        }
        return version;
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Trees trees = Trees.instance(DynamicProxyProcessor.jbUnwrap(ProcessingEnvironment.class, this.processingEnv));
        for (Element element : roundEnvironment.getElementsAnnotatedWith(Proxy.class)) {
            this.processElement(element, trees);
        }
        return false;
    }

    private void processElement(Element element, Trees trees) {
        String code;
        CompilationUnit compilationUnit;
        TypeMirror typeMirror;
        Proxy proxy = element.getAnnotation(Proxy.class);
        try {
            typeMirror = this.processingEnv.getElementUtils().getTypeElement(proxy.value().getName()).asType();
        }
        catch (MirroredTypeException e) {
            typeMirror = e.getTypeMirror();
        }
        if (!(typeMirror instanceof DeclaredType) || ((DeclaredType)typeMirror).asElement().getKind() != ElementKind.INTERFACE) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The value of @Proxy needs to be a interface", element);
            return;
        }
        String originalField = null;
        if (!(element instanceof TypeElement) || !element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Must be an abstract class", element);
            return;
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.FIELD || element2.getAnnotation(Original.class) == null) continue;
            if (!this.processingEnv.getTypeUtils().isAssignable(typeMirror, element2.asType())) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@Original needs to be assignable to " + typeMirror, element2);
                return;
            }
            if (originalField != null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate @Original field", element2);
                return;
            }
            originalField = element2.getSimpleName().toString();
        }
        TypeElement superClass = (TypeElement)((DeclaredType)((TypeElement)element).getSuperclass()).asElement();
        if (!superClass.getQualifiedName().toString().equals(Object.class.getName())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot be used on subclasses", element);
            return;
        }
        JavaFileObject javaFileObject = trees.getPath(element).getCompilationUnit().getSourceFile();
        final JavaParser javaParser = new JavaParser(new ParserConfiguration().setSymbolResolver((SymbolResolver)new JavaSymbolSolver((TypeSolver)new ClassLoaderTypeSolver(this.getClass().getClassLoader()))));
        try (InputStream inputStream = javaFileObject.openInputStream();){
            ParseResult parseResult = javaParser.parse(inputStream);
            compilationUnit = parseResult.getResult().orElse(null);
            if (compilationUnit == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Java parse failure: " + parseResult.getProblem(0).getMessage());
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        final String originalFieldName = originalField != null ? originalField : "original";
        String packageName = this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString();
        String originalName = element.getSimpleName().toString();
        final String proxyName = proxy.className().isEmpty() ? originalName + proxy.suffix() : proxy.className();
        final String proxyTypeName = ((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString();
        final String finalOriginalField = originalField;
        final AtomicBoolean hasProxyImport = new AtomicBoolean(false);
        final AtomicBoolean hasOriginalImport = new AtomicBoolean(false);
        compilationUnit.accept((GenericVisitor)new ModifierVisitor<Void>(){

            private boolean checkImport(Class<?> annotation, AtomicBoolean hasImport, ImportDeclaration n) {
                String name = n.getNameAsString();
                if (name.equals(annotation.getPackage().getName())) {
                    hasImport.set(true);
                } else if (name.equals(annotation.getName())) {
                    hasImport.set(true);
                    return true;
                }
                return false;
            }

            public Node visit(ImportDeclaration n, Void arg) {
                if (this.checkImport(Proxy.class, hasProxyImport, n)) {
                    return null;
                }
                if (this.checkImport(Original.class, hasOriginalImport, n)) {
                    return null;
                }
                return super.visit(n, (Object)arg);
            }

            public Visitable visit(PackageDeclaration n, Void arg) {
                n.setComment((Comment)new JavadocComment("Class generated by DynamicProxy"));
                return super.visit(n, (Object)arg);
            }

            private Predicate<AnnotationExpr> removeAnnotation(Class<?> annotationType, AtomicBoolean hasImport) {
                return annotation -> {
                    String name = annotation.getNameAsString();
                    if (hasImport.get() && name.equals(annotationType.getSimpleName())) {
                        return true;
                    }
                    return name.equals(annotationType.getName());
                };
            }

            public Visitable visit(ClassOrInterfaceDeclaration n, Void arg) {
                if (n.getParentNode().orElse(null) != compilationUnit) {
                    return super.visit(n, (Object)arg);
                }
                NodeList annotations = n.getAnnotations();
                annotations.removeIf(this.removeAnnotation(Proxy.class, hasProxyImport));
                n.setAnnotations(annotations);
                n.setName(proxyName);
                n.removeModifier(new Modifier.Keyword[]{Modifier.Keyword.ABSTRACT});
                n.setImplementedTypes(new NodeList());
                n.addFieldWithInitializer(DYNAMIC_PROXY_CLASS_NAME, "$DYNAMICPROXY", (Expression)new MethodCallExpr("new " + DYNAMIC_PROXY_CLASS_NAME, new Expression[]{new ClassExpr((Type)javaParser.parseClassOrInterfaceType(proxyName).getResult().orElseThrow(IllegalStateException::new))}), new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL});
                n.addFieldWithInitializer(proxyTypeName, "$PROXY", (Expression)new NullLiteralExpr(), new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
                MethodDeclaration method = n.addMethod("getProxy", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.FINAL});
                method.setType(proxyTypeName);
                ClassOrInterfaceType proxyType = (ClassOrInterfaceType)javaParser.parseClassOrInterfaceType(proxyTypeName).getResult().orElseThrow(IllegalStateException::new);
                if (finalOriginalField == null) {
                    NodeList nodeList = new NodeList();
                    nodeList.add((Node)new Parameter((Type)proxyType, "original"));
                    method.setParameters(nodeList);
                }
                FieldAccessExpr original = finalOriginalField != null ? new FieldAccessExpr((Expression)new ThisExpr(), originalFieldName) : new NameExpr("original");
                BlockStmt body = new BlockStmt();
                body.addStatement((Statement)new IfStmt((Expression)new BinaryExpr((Expression)original, (Expression)new NullLiteralExpr(), BinaryExpr.Operator.EQUALS), (Statement)new ThrowStmt((Expression)new MethodCallExpr("new java.lang.NullPointerException", new Expression[]{new StringLiteralExpr(originalFieldName)})), null));
                FieldAccessExpr proxyField = new FieldAccessExpr((Expression)new ThisExpr(), "$PROXY");
                body.addStatement((Statement)new ReturnStmt((Expression)new ConditionalExpr((Expression)new BinaryExpr((Expression)proxyField, (Expression)new NullLiteralExpr(), BinaryExpr.Operator.NOT_EQUALS), (Expression)proxyField, (Expression)new EnclosedExpr((Expression)new AssignExpr((Expression)proxyField, (Expression)new CastExpr((Type)proxyType, (Expression)new MethodCallExpr("$DYNAMICPROXY.make", new Expression[]{original, new ThisExpr()})), AssignExpr.Operator.ASSIGN)))));
                method.setBody(body);
                return super.visit(n, (Object)arg);
            }

            public Visitable visit(FieldDeclaration n, Void arg) {
                NodeList annotations = n.getAnnotations();
                annotations.removeIf(this.removeAnnotation(Original.class, hasOriginalImport));
                n.setAnnotations(annotations);
                return super.visit(n, (Object)arg);
            }

            public Visitable visit(ConstructorDeclaration n, Void arg) {
                if (n.getParentNode().flatMap(Node::getParentNode).orElse(null) != compilationUnit) {
                    return super.visit(n, (Object)arg);
                }
                n.setName(proxyName);
                n.getBody().accept((GenericVisitor)new ModifierVisitor<Void>(){

                    public Visitable visit(ExplicitConstructorInvocationStmt n, Void arg) {
                        n.remove();
                        return super.visit(n, (Object)arg);
                    }
                }, null);
                return super.visit(n, (Object)arg);
            }

            public Visitable visit(MethodDeclaration n, Void arg) {
                NodeList annotations = n.getAnnotations();
                annotations.removeIf(annotation -> {
                    try {
                        return annotation.resolve().getQualifiedName().equals(Override.class.getName());
                    }
                    catch (UnsolvedSymbolException ignored) {
                        return false;
                    }
                });
                n.setAnnotations(annotations);
                return super.visit(n, (Object)arg);
            }
        }, null);
        try {
            Class<CompilationUnit> cuClass = CompilationUnit.class;
            Method getPrinter = cuClass.getDeclaredMethod("getPrinter", new Class[0]);
            getPrinter.setAccessible(true);
            Printer printer = (Printer)getPrinter.invoke((Object)compilationUnit, new Object[0]);
            code = printer.print((Node)compilationUnit);
        }
        catch (ReflectiveOperationException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to generate: " + e);
            return;
        }
        try {
            JavaFileObject javaFileObject2 = this.processingEnv.getFiler().createSourceFile(packageName + "." + proxyName, new Element[0]);
            try (PrintWriter printWriter = new PrintWriter(javaFileObject2.openWriter());){
                printWriter.write(code);
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to save output: " + e);
        }
    }

    private static <T> T jbUnwrap(Class<? extends T> iface, T wrapper) {
        T unwrapped = null;
        try {
            Class<?> apiWrappers = wrapper.getClass().getClassLoader().loadClass("org.jetbrains.jps.javac.APIWrappers");
            Method unwrapMethod = apiWrappers.getDeclaredMethod("unwrap", Class.class, Object.class);
            unwrapped = iface.cast(unwrapMethod.invoke(null, iface, wrapper));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unwrapped != null ? unwrapped : (T)wrapper;
    }
}

