/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.dynamicproxy;

import dev.vankka.dynamicproxy.InvocationError;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DynamicProxy {
    private final Map<String, List<Method>> methods = new HashMap<String, List<Method>>();

    public DynamicProxy(@NotNull Class<?> proxyType) {
        for (Method method : proxyType.getDeclaredMethods()) {
            this.methods.computeIfAbsent(method.getName(), key -> new ArrayList()).add(method);
        }
    }

    @NotNull
    public Object make(@NotNull Object original, @NotNull Object proxy) {
        Class<?> originalClass = original.getClass();
        LinkedHashSet interfaces = new LinkedHashSet();
        this.getAllInterfaces(original.getClass(), interfaces);
        return Proxy.newProxyInstance(originalClass.getClassLoader(), interfaces.toArray(new Class[0]), (InvocationHandler)new Handler(original, proxy));
    }

    private void getAllInterfaces(Class<?> clazz, Set<Class<?>> interfaces) {
        while (clazz != null) {
            for (Class<?> theInterface : clazz.getInterfaces()) {
                if (!interfaces.add(theInterface)) continue;
                this.getAllInterfaces(theInterface, interfaces);
            }
            clazz = clazz.getSuperclass();
        }
    }

    private class Handler
    implements InvocationHandler {
        private final Object original;
        private final Object proxy;

        public Handler(Object original, Object proxy) {
            this.original = original;
            this.proxy = proxy;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] args) throws Throwable {
            List methodList = (List)DynamicProxy.this.methods.get(method.getName());
            if (methodList != null) {
                int parameterCount = method.getParameterCount();
                Object[] parameterTypes = method.getParameterTypes();
                for (Method proxyMethod : methodList) {
                    if (proxyMethod.getParameterCount() != parameterCount || !Arrays.equals(proxyMethod.getParameterTypes(), parameterTypes)) continue;
                    return this.invokeMethod(proxyMethod, args);
                }
            }
            return method.invoke(this.original, args);
        }

        private Object invokeMethod(Method proxyMethod, Object[] args) {
            try {
                proxyMethod.setAccessible(true);
                return proxyMethod.invoke(this.proxy, args);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new InvocationError(e);
            }
        }
    }
}

