/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.kafka.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaProducer<T> {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducer.class);
    private final KafkaTemplate<String, T> kafkaTemplate;

    public void send(String topic, T payload) {
        log.info("Sending payload='{}' to topic='{}'", payload, (Object)topic);
        this.kafkaTemplate.send(topic, payload).join();
        this.kafkaTemplate.getProducerFactory().reset();
    }

    public void send(String topic, String key, T payload) {
        log.info("Sending key='{}' payload='{}' to topic='{}'", new Object[]{key, payload, topic});
        this.kafkaTemplate.send(topic, (Object)key, payload).join();
        this.kafkaTemplate.getProducerFactory().reset();
    }

    public KafkaProducer(KafkaTemplate<String, T> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

