/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.ceph;

import dev.vality.testcontainers.annotations.util.GenericContainerUtil;
import dev.vality.testcontainers.annotations.util.SpringApplicationPropertiesLoader;
import java.time.Duration;
import java.util.UUID;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class CephTestcontainerFactory {
    private final Object $lock = new Object[0];
    public static final String ACCESS_KEY = "testcontainers.ceph.accessKey";
    public static final String SECRET_KEY = "testcontainers.ceph.secretKey";
    private static final String CEPH_DAEMON_IMAGE_NAME = "ceph/daemon";
    private static final String TAG_PROPERTY = "testcontainers.ceph.tag";
    private GenericContainer<?> cephDaemonContainer;

    public static GenericContainer<?> container() {
        return CephTestcontainerFactory.instance().create();
    }

    public static GenericContainer<?> singletonContainer() {
        return CephTestcontainerFactory.instance().getOrCreateSingletonContainer();
    }

    private static CephTestcontainerFactory instance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericContainer<?> getOrCreateSingletonContainer() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.cephDaemonContainer != null) {
                return this.cephDaemonContainer;
            }
            this.cephDaemonContainer = this.create();
            return this.cephDaemonContainer;
        }
    }

    private GenericContainer<?> create() {
        try (GenericContainer container = new GenericContainer(DockerImageName.parse((String)CEPH_DAEMON_IMAGE_NAME).withTag(SpringApplicationPropertiesLoader.loadDefaultLibraryProperty(TAG_PROPERTY))).withExposedPorts(new Integer[]{5000, 8080}).withNetworkAliases(new String[]{"ceph-daemon-" + UUID.randomUUID()}).withEnv("RGW_NAME", "localhost").withEnv("NETWORK_AUTO_DETECT", "4").withEnv("CEPH_DAEMON", "demo").withEnv("CEPH_DEMO_UID", "ceph-test").withEnv("CEPH_DEMO_ACCESS_KEY", SpringApplicationPropertiesLoader.loadDefaultLibraryProperty(ACCESS_KEY)).withEnv("CEPH_DEMO_SECRET_KEY", SpringApplicationPropertiesLoader.loadDefaultLibraryProperty(SECRET_KEY)).withEnv("CEPH_DEMO_BUCKET", "TEST").waitingFor(GenericContainerUtil.getWaitStrategy("/api/v0.1/health", 200, 5000, Duration.ofMinutes(1L)));){
            GenericContainer genericContainer = container;
            return genericContainer;
        }
    }

    private CephTestcontainerFactory() {
    }

    private static class SingletonHolder {
        private static final CephTestcontainerFactory INSTANCE = new CephTestcontainerFactory();

        private SingletonHolder() {
        }
    }
}

