/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.postgresql;

import dev.vality.testcontainers.annotations.postgresql.PostgresqlTestcontainer;
import dev.vality.testcontainers.annotations.postgresql.PostgresqlTestcontainerFactory;
import dev.vality.testcontainers.annotations.postgresql.PostgresqlTestcontainerSingleton;
import dev.vality.testcontainers.annotations.util.GenericContainerUtil;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.testcontainers.containers.PostgreSQLContainer;

public class PostgresqlTestcontainerExtension
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger log = LoggerFactory.getLogger(PostgresqlTestcontainerExtension.class);
    private static final ThreadLocal<PostgreSQLContainer<?>> THREAD_CONTAINER = new ThreadLocal();

    public void beforeAll(ExtensionContext context) {
        if (PostgresqlTestcontainerExtension.findPrototypeAnnotation(context).isPresent()) {
            PostgreSQLContainer<?> container = PostgresqlTestcontainerFactory.container();
            GenericContainerUtil.startContainer(container);
            THREAD_CONTAINER.set(container);
        } else if (PostgresqlTestcontainerExtension.findSingletonAnnotation(context).isPresent()) {
            PostgreSQLContainer<?> container = PostgresqlTestcontainerFactory.singletonContainer();
            if (!container.isRunning()) {
                GenericContainerUtil.startContainer(container);
            }
            THREAD_CONTAINER.set(container);
        }
    }

    public void afterAll(ExtensionContext context) {
        if (PostgresqlTestcontainerExtension.findPrototypeAnnotation(context).isPresent()) {
            PostgreSQLContainer<?> container = THREAD_CONTAINER.get();
            if (container != null && container.isRunning()) {
                container.stop();
            }
            THREAD_CONTAINER.remove();
        } else if (PostgresqlTestcontainerExtension.findSingletonAnnotation(context).isPresent()) {
            THREAD_CONTAINER.remove();
        }
    }

    private static Optional<PostgresqlTestcontainer> findPrototypeAnnotation(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), PostgresqlTestcontainer.class);
    }

    private static Optional<PostgresqlTestcontainer> findPrototypeAnnotation(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, PostgresqlTestcontainer.class);
    }

    private static Optional<PostgresqlTestcontainerSingleton> findSingletonAnnotation(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), PostgresqlTestcontainerSingleton.class);
    }

    private static Optional<PostgresqlTestcontainerSingleton> findSingletonAnnotation(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, PostgresqlTestcontainerSingleton.class);
    }

    public static class PostgresqlTestcontainerContextCustomizerFactory
    implements ContextCustomizerFactory {
        public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
            return (context, mergedConfig) -> {
                if (PostgresqlTestcontainerExtension.findPrototypeAnnotation(testClass).isPresent()) {
                    this.init(context, PostgresqlTestcontainerExtension.findPrototypeAnnotation(testClass).get().properties());
                } else if (PostgresqlTestcontainerExtension.findSingletonAnnotation(testClass).isPresent()) {
                    this.init(context, PostgresqlTestcontainerExtension.findSingletonAnnotation(testClass).get().properties());
                }
            };
        }

        private void init(ConfigurableApplicationContext context, String[] properties) {
            PostgreSQLContainer<?> container = THREAD_CONTAINER.get();
            String jdbcUrl = container.getJdbcUrl();
            String username = container.getUsername();
            String password = container.getPassword();
            TestPropertyValues.of((String[])new String[]{"spring.datasource.url=" + jdbcUrl, "spring.datasource.username=" + username, "spring.datasource.password=" + password, "spring.flyway.url=" + jdbcUrl, "spring.flyway.user=" + username, "spring.flyway.password=" + password, "flyway.url=" + jdbcUrl, "flyway.user=" + username, "flyway.password=" + password}).and(properties).applyTo(context);
        }
    }
}

