/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.minio;

import dev.vality.testcontainers.annotations.util.GenericContainerUtil;
import dev.vality.testcontainers.annotations.util.SpringApplicationPropertiesLoader;
import java.time.Duration;
import java.util.UUID;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class MinioTestcontainerFactory {
    private final Object $lock = new Object[0];
    public static final String MINIO_USER = "testcontainers.minio.user";
    public static final String MINIO_PASSWORD = "testcontainers.minio.password";
    private static final String MINIO_IMAGE_NAME = "quay.io/minio/minio";
    private static final String TAG_PROPERTY = "testcontainers.minio.tag";
    private GenericContainer<?> minioContainer;

    public static GenericContainer<?> container() {
        return MinioTestcontainerFactory.instance().create();
    }

    public static GenericContainer<?> singletonContainer() {
        return MinioTestcontainerFactory.instance().getOrCreateSingletonContainer();
    }

    private static MinioTestcontainerFactory instance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericContainer<?> getOrCreateSingletonContainer() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.minioContainer != null) {
                return this.minioContainer;
            }
            this.minioContainer = this.create();
            return this.minioContainer;
        }
    }

    private GenericContainer<?> create() {
        try (GenericContainer container = new GenericContainer(DockerImageName.parse((String)MINIO_IMAGE_NAME).withTag(SpringApplicationPropertiesLoader.loadDefaultLibraryProperty(TAG_PROPERTY))).withExposedPorts(new Integer[]{9000}).withNetworkAliases(new String[]{"minio-" + UUID.randomUUID()}).withEnv("MINIO_ROOT_USER", SpringApplicationPropertiesLoader.loadDefaultLibraryProperty(MINIO_USER)).withEnv("MINIO_ROOT_PASSWORD", SpringApplicationPropertiesLoader.loadDefaultLibraryProperty(MINIO_PASSWORD)).withCommand("server /data{1...12}").waitingFor(GenericContainerUtil.getWaitStrategy("/minio/health/live", 200, 9000, Duration.ofMinutes(1L)));){
            GenericContainer genericContainer = container;
            return genericContainer;
        }
    }

    private MinioTestcontainerFactory() {
    }

    private static class SingletonHolder {
        private static final MinioTestcontainerFactory INSTANCE = new MinioTestcontainerFactory();

        private SingletonHolder() {
        }
    }
}

