/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.kafka.config;

import dev.vality.kafka.common.serialization.ThriftSerializer;
import dev.vality.testcontainers.annotations.kafka.config.KafkaProducer;
import java.util.HashMap;
import java.util.UUID;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.thrift.TBase;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@TestConfiguration
public class KafkaProducerConfig {
    @Value(value="${kafka.bootstrap-servers}")
    private String bootstrapAddress;

    @Bean
    public KafkaProducer<TBase<?, ?>> testThriftKafkaProducer() {
        return new KafkaProducer(new KafkaTemplate(this.thriftProducerFactory()));
    }

    private ProducerFactory<String, TBase<?, ?>> thriftProducerFactory() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("bootstrap.servers", this.bootstrapAddress);
        props.put("client.id", UUID.randomUUID().toString());
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", ThriftSerializer.class.getName());
        return new DefaultKafkaProducerFactory(props);
    }
}

