/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.util;

import dev.vality.testcontainers.annotations.exception.IoException;
import dev.vality.testcontainers.annotations.exception.NoSuchFileException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SpringApplicationPropertiesLoader {
    public static String loadDefaultLibraryProperty(String key) {
        Object tag = SpringApplicationPropertiesLoader.loadPropertiesByFile().get(key);
        if (tag == null) {
            tag = SpringApplicationPropertiesLoader.getSource(PropertiesFileParameters.builder().propertySourceLoader(YamlPropertySourceLoader::new).name("testcontainers-annotations.yml").build()).get(key);
        }
        return String.valueOf(tag);
    }

    public static Properties loadFromSpringApplicationPropertiesFile(List<String> keys) {
        Map<String, Object> fileProperties = SpringApplicationPropertiesLoader.loadPropertiesByFile();
        Map<String, Object> filtered = fileProperties.entrySet().stream().filter(entry -> keys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Assertions.assertThat(filtered.keySet()).containsAll(keys);
        Properties properties = new Properties();
        properties.putAll(filtered);
        return properties;
    }

    private static Map<String, Object> loadPropertiesByFile() {
        PropertiesFileParameters parameters = SpringApplicationPropertiesLoader.findPropertiesFileParameters();
        return SpringApplicationPropertiesLoader.getSource(parameters);
    }

    private static Map<String, Object> getSource(PropertiesFileParameters parameters) {
        Class<SpringApplicationPropertiesLoader> currentClass = SpringApplicationPropertiesLoader.class;
        ClassPathResource classPathResource = new ClassPathResource(parameters.getName(), currentClass.getClassLoader());
        try {
            return ((Map)((PropertySource)parameters.getPropertySourceLoader().get().load(classPathResource.getFilename(), (Resource)classPathResource).get(0)).getSource()).entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, Object>((String)entry.getKey(), ((OriginTrackedValue)entry.getValue()).getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (IOException ex) {
            throw new IoException("Error when loading properties, ", ex);
        }
    }

    private static PropertiesFileParameters findPropertiesFileParameters() {
        Class<SpringApplicationPropertiesLoader> currentClass = SpringApplicationPropertiesLoader.class;
        if (currentClass.getResource("/application.yml") != null) {
            return PropertiesFileParameters.builder().propertySourceLoader(YamlPropertySourceLoader::new).name("application.yml").build();
        }
        if (currentClass.getResource("/application.properties") != null) {
            return PropertiesFileParameters.builder().propertySourceLoader(PropertiesPropertySourceLoader::new).name("application.properties").build();
        }
        if (currentClass.getResource("/application.xml") != null) {
            return PropertiesFileParameters.builder().propertySourceLoader(PropertiesPropertySourceLoader::new).name("application.xml").build();
        }
        throw new NoSuchFileException("Error on load src/main/resources/application.[yml|properties|xml] \u2014 file not found");
    }

    private static class PropertiesFileParameters {
        private Supplier<PropertySourceLoader> propertySourceLoader;
        private String name;

        PropertiesFileParameters(Supplier<PropertySourceLoader> propertySourceLoader, String name) {
            this.propertySourceLoader = propertySourceLoader;
            this.name = name;
        }

        public static PropertiesFileParametersBuilder builder() {
            return new PropertiesFileParametersBuilder();
        }

        public Supplier<PropertySourceLoader> getPropertySourceLoader() {
            return this.propertySourceLoader;
        }

        public String getName() {
            return this.name;
        }

        public void setPropertySourceLoader(Supplier<PropertySourceLoader> propertySourceLoader) {
            this.propertySourceLoader = propertySourceLoader;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertiesFileParameters)) {
                return false;
            }
            PropertiesFileParameters other = (PropertiesFileParameters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Supplier<PropertySourceLoader> this$propertySourceLoader = this.getPropertySourceLoader();
            Supplier<PropertySourceLoader> other$propertySourceLoader = other.getPropertySourceLoader();
            if (this$propertySourceLoader == null ? other$propertySourceLoader != null : !this$propertySourceLoader.equals(other$propertySourceLoader)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertiesFileParameters;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Supplier<PropertySourceLoader> $propertySourceLoader = this.getPropertySourceLoader();
            result = result * 59 + ($propertySourceLoader == null ? 43 : $propertySourceLoader.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "SpringApplicationPropertiesLoader.PropertiesFileParameters(propertySourceLoader=" + this.getPropertySourceLoader() + ", name=" + this.getName() + ")";
        }

        public static class PropertiesFileParametersBuilder {
            private Supplier<PropertySourceLoader> propertySourceLoader;
            private String name;

            PropertiesFileParametersBuilder() {
            }

            public PropertiesFileParametersBuilder propertySourceLoader(Supplier<PropertySourceLoader> propertySourceLoader) {
                this.propertySourceLoader = propertySourceLoader;
                return this;
            }

            public PropertiesFileParametersBuilder name(String name) {
                this.name = name;
                return this;
            }

            public PropertiesFileParameters build() {
                return new PropertiesFileParameters(this.propertySourceLoader, this.name);
            }

            public String toString() {
                return "SpringApplicationPropertiesLoader.PropertiesFileParameters.PropertiesFileParametersBuilder(propertySourceLoader=" + this.propertySourceLoader + ", name=" + this.name + ")";
            }
        }
    }
}

