/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.util;

import java.time.Duration;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startables;

public class GenericContainerUtil {
    public static void startContainer(GenericContainer<?> container) {
        Startables.deepStart(Stream.of(container)).join();
        Assertions.assertThat((boolean)container.isRunning()).isTrue();
    }

    public static WaitStrategy getWaitStrategy(String path, Integer statusCode, Integer port, Duration duration) {
        return new HttpWaitStrategy().forPath(path).forPort(port.intValue()).forStatusCode(statusCode.intValue()).withStartupTimeout(duration);
    }
}

