/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.kafka.config;

import dev.vality.kafka.common.serialization.AbstractThriftDeserializer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.thrift.TBase;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.MessageListener;

public class KafkaConsumer<T extends TBase<?, ?>> {
    private final String bootstrapAddress;
    private final AbstractThriftDeserializer<T> deserializer;

    public void read(String topic, MessageListener<String, T> messageListener) {
        ConcurrentMessageListenerContainer container = new ConcurrentMessageListenerContainer(this.consumerFactory(), this.containerProperties(topic, messageListener));
        container.start();
    }

    private ContainerProperties containerProperties(String topic, MessageListener<String, T> messageListener) {
        ContainerProperties containerProperties = new ContainerProperties(new String[]{topic});
        containerProperties.setMessageListener(messageListener);
        return containerProperties;
    }

    private DefaultKafkaConsumerFactory<String, T> consumerFactory() {
        return new DefaultKafkaConsumerFactory(this.consumerConfig(), (Deserializer)new StringDeserializer(), this.deserializer);
    }

    private Map<String, Object> consumerConfig() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bootstrap.servers", this.bootstrapAddress);
        properties.put("group.id", UUID.randomUUID().toString());
        properties.put("auto.offset.reset", "earliest");
        return properties;
    }

    public KafkaConsumer(String bootstrapAddress, AbstractThriftDeserializer<T> deserializer) {
        this.bootstrapAddress = bootstrapAddress;
        this.deserializer = deserializer;
    }
}

