/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.postgresql;

import dev.vality.testcontainers.annotations.util.SpringApplicationPropertiesLoader;
import java.util.UUID;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class PostgresqlTestcontainerFactory {
    private final Object $lock = new Object[0];
    private static final String POSTGRESQL_IMAGE_NAME = "postgres";
    private static final String TAG_PROPERTY = "testcontainers.postgresql.tag";
    private PostgreSQLContainer<?> postgreSqlContainer;

    public static PostgreSQLContainer<?> container() {
        return PostgresqlTestcontainerFactory.instance().create();
    }

    public static PostgreSQLContainer<?> singletonContainer() {
        return PostgresqlTestcontainerFactory.instance().getOrCreateSingletonContainer();
    }

    private static PostgresqlTestcontainerFactory instance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PostgreSQLContainer<?> getOrCreateSingletonContainer() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.postgreSqlContainer != null) {
                return this.postgreSqlContainer;
            }
            this.postgreSqlContainer = this.create();
            return this.postgreSqlContainer;
        }
    }

    private PostgreSQLContainer<?> create() {
        try (PostgreSQLContainer container = new PostgreSQLContainer(DockerImageName.parse((String)POSTGRESQL_IMAGE_NAME).withTag(SpringApplicationPropertiesLoader.loadDefaultLibraryProperty(TAG_PROPERTY)));){
            container.withNetworkAliases(new String[]{"postgres-" + UUID.randomUUID()});
            PostgreSQLContainer postgreSQLContainer = container;
            return postgreSQLContainer;
        }
    }

    private PostgresqlTestcontainerFactory() {
    }

    private static class SingletonHolder {
        private static final PostgresqlTestcontainerFactory INSTANCE = new PostgresqlTestcontainerFactory();

        private SingletonHolder() {
        }
    }
}

