/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.minio;

import dev.vality.testcontainers.annotations.minio.MinioTestcontainer;
import dev.vality.testcontainers.annotations.minio.MinioTestcontainerFactory;
import dev.vality.testcontainers.annotations.minio.MinioTestcontainerSingleton;
import dev.vality.testcontainers.annotations.util.GenericContainerUtil;
import dev.vality.testcontainers.annotations.util.SpringApplicationPropertiesLoader;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.testcontainers.containers.GenericContainer;

public class MinioTestcontainerExtension
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger log = LoggerFactory.getLogger(MinioTestcontainerExtension.class);
    private static final ThreadLocal<GenericContainer<?>> THREAD_CONTAINER = new ThreadLocal();

    public void beforeAll(ExtensionContext context) {
        if (MinioTestcontainerExtension.findPrototypeAnnotation(context).isPresent()) {
            GenericContainer<?> container = MinioTestcontainerFactory.container();
            GenericContainerUtil.startContainer(container);
            THREAD_CONTAINER.set(container);
        } else if (MinioTestcontainerExtension.findSingletonAnnotation(context).isPresent()) {
            GenericContainer<?> container = MinioTestcontainerFactory.singletonContainer();
            if (!container.isRunning()) {
                GenericContainerUtil.startContainer(container);
            }
            THREAD_CONTAINER.set(container);
        }
    }

    public void afterAll(ExtensionContext context) {
        if (MinioTestcontainerExtension.findPrototypeAnnotation(context).isPresent()) {
            GenericContainer<?> container = THREAD_CONTAINER.get();
            if (container != null && container.isRunning()) {
                container.stop();
            }
            THREAD_CONTAINER.remove();
        } else if (MinioTestcontainerExtension.findSingletonAnnotation(context).isPresent()) {
            THREAD_CONTAINER.remove();
        }
    }

    private static Optional<MinioTestcontainer> findPrototypeAnnotation(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), MinioTestcontainer.class);
    }

    private static Optional<MinioTestcontainer> findPrototypeAnnotation(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, MinioTestcontainer.class);
    }

    private static Optional<MinioTestcontainerSingleton> findSingletonAnnotation(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), MinioTestcontainerSingleton.class);
    }

    private static Optional<MinioTestcontainerSingleton> findSingletonAnnotation(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, MinioTestcontainerSingleton.class);
    }

    public static class MinioTestcontainerContextCustomizerFactory
    implements ContextCustomizerFactory {
        public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
            return (context, mergedConfig) -> {
                if (MinioTestcontainerExtension.findPrototypeAnnotation(testClass).isPresent()) {
                    MinioTestcontainer annotation2 = MinioTestcontainerExtension.findPrototypeAnnotation(testClass).get();
                    this.init(context, annotation2.bucketName(), annotation2.properties());
                } else {
                    MinioTestcontainerExtension.findSingletonAnnotation(testClass).ifPresent(annotation -> this.init(context, annotation.bucketName(), annotation.properties()));
                }
            };
        }

        private void init(ConfigurableApplicationContext context, String bucketName, String[] properties) {
            GenericContainer<?> container = THREAD_CONTAINER.get();
            TestPropertyValues.of((String[])new String[]{"storage.endpoint=" + container.getContainerIpAddress() + ":" + container.getMappedPort(9000), "storage.accessKey=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.minio.user"), "storage.secretKey=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.minio.password"), "storage.bucketName=" + bucketName, "s3.endpoint=" + container.getContainerIpAddress() + ":" + container.getMappedPort(9000), "s3.bucket-name=" + bucketName, "s3.access-key=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.minio.user"), "s3.secret-key=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.minio.password"), "s3-sdk-v2.enabled=false", "s3-sdk-v2.endpoint=" + String.format("http://%s:%d/", container.getHost(), container.getMappedPort(9000)), "s3-sdk-v2.bucket-name=" + bucketName, "s3-sdk-v2.access-key=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.minio.user"), "s3-sdk-v2.secret-key=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.minio.password")}).and(properties).applyTo(context);
        }
    }
}

