/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.kafka.config;

import com.rbkmoney.kafka.common.serialization.AbstractThriftDeserializer;
import com.rbkmoney.machinegun.eventsink.SinkEvent;
import dev.vality.damsel.fraudbusters.Command;
import dev.vality.payout.manager.Event;
import dev.vality.testcontainers.annotations.kafka.config.KafkaConsumer;
import org.apache.thrift.TBase;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;

@TestConfiguration
public class KafkaConsumerConfig {
    @Value(value="${kafka.bootstrap-servers}")
    private String bootstrapAddress;

    @Bean
    public KafkaConsumer<SinkEvent> testSinkEventKafkaConsumer() {
        return new KafkaConsumer<SinkEvent>(this.bootstrapAddress, new SinkEventDeserializer());
    }

    @Bean
    public KafkaConsumer<Event> testPayoutEventKafkaConsumer() {
        return new KafkaConsumer<Event>(this.bootstrapAddress, new PayoutEventDeserializer());
    }

    @Bean
    public KafkaConsumer<Command> testFraudbustersCommandKafkaConsumer() {
        return new KafkaConsumer<Command>(this.bootstrapAddress, new FraudbustersCommandDeserializer());
    }

    public static class SinkEventDeserializer
    extends AbstractThriftDeserializer<SinkEvent> {
        public SinkEvent deserialize(String s, byte[] bytes) {
            return (SinkEvent)super.deserialize(bytes, (TBase)new SinkEvent());
        }
    }

    public static class PayoutEventDeserializer
    extends AbstractThriftDeserializer<Event> {
        public Event deserialize(String s, byte[] bytes) {
            return (Event)super.deserialize(bytes, (TBase)new Event());
        }
    }

    public static class FraudbustersCommandDeserializer
    extends AbstractThriftDeserializer<Command> {
        public Command deserialize(String s, byte[] bytes) {
            return (Command)super.deserialize(bytes, (TBase)new Command());
        }
    }
}

