/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.kafka;

import dev.vality.testcontainers.annotations.util.SpringApplicationPropertiesLoader;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.utility.DockerImageName;

public class KafkaTestcontainerFactory {
    private static final Logger log = LoggerFactory.getLogger(KafkaTestcontainerFactory.class);
    private final Object $lock = new Object[0];
    private static final String KAFKA_IMAGE_NAME = "confluentinc/cp-kafka";
    private static final String TAG_PROPERTY = "testcontainers.kafka.tag";
    private KafkaContainer kafkaContainer;

    public static KafkaContainer container() {
        return KafkaTestcontainerFactory.instance().create();
    }

    public static KafkaContainer singletonContainer() {
        return KafkaTestcontainerFactory.instance().getOrCreateSingletonContainer();
    }

    private static KafkaTestcontainerFactory instance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KafkaContainer getOrCreateSingletonContainer() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.kafkaContainer != null) {
                return this.kafkaContainer;
            }
            this.kafkaContainer = this.create();
            return this.kafkaContainer;
        }
    }

    private KafkaContainer create() {
        try (KafkaContainer container = (KafkaContainer)new KafkaContainer(DockerImageName.parse((String)KAFKA_IMAGE_NAME).withTag(SpringApplicationPropertiesLoader.loadDefaultLibraryProperty(TAG_PROPERTY))).withEmbeddedZookeeper().withEnv("KAFKA_DELETE_TOPIC_ENABLE", "true");){
            container.withNetworkAliases(new String[]{"cp-kafka-" + UUID.randomUUID()});
            KafkaContainer kafkaContainer = container;
            return kafkaContainer;
        }
    }

    private KafkaTestcontainerFactory() {
    }

    private static class SingletonHolder {
        private static final KafkaTestcontainerFactory INSTANCE = new KafkaTestcontainerFactory();

        private SingletonHolder() {
        }
    }
}

