/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.clickhouse;

import dev.vality.testcontainers.annotations.util.SpringApplicationPropertiesLoader;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ClickHouseContainer;
import org.testcontainers.utility.DockerImageName;

public class ClickhouseTestcontainerFactory {
    private static final Logger log = LoggerFactory.getLogger(ClickhouseTestcontainerFactory.class);
    private final Object $lock = new Object[0];
    private static final String CLICKHOUSE_IMAGE_NAME = "yandex/clickhouse-server";
    private static final String TAG_PROPERTY = "testcontainers.clickhouse.tag";
    private ClickHouseContainer clickHouseContainer;

    public static ClickHouseContainer container() {
        return ClickhouseTestcontainerFactory.instance().create();
    }

    public static ClickHouseContainer singletonContainer() {
        return ClickhouseTestcontainerFactory.instance().getOrCreateSingletonContainer();
    }

    private static ClickhouseTestcontainerFactory instance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClickHouseContainer getOrCreateSingletonContainer() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.clickHouseContainer != null) {
                return this.clickHouseContainer;
            }
            this.clickHouseContainer = this.create();
            return this.clickHouseContainer;
        }
    }

    private ClickHouseContainer create() {
        try (ClickHouseContainer container = new ClickHouseContainer(DockerImageName.parse((String)CLICKHOUSE_IMAGE_NAME).withTag(SpringApplicationPropertiesLoader.loadDefaultLibraryProperty(TAG_PROPERTY)));){
            container.withNetworkAliases(new String[]{"clickhouse-server-" + UUID.randomUUID()});
            ClickHouseContainer clickHouseContainer = container;
            return clickHouseContainer;
        }
    }

    private ClickhouseTestcontainerFactory() {
    }

    private static class SingletonHolder {
        private static final ClickhouseTestcontainerFactory INSTANCE = new ClickhouseTestcontainerFactory();

        private SingletonHolder() {
        }
    }
}

