/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.clickhouse;

import com.rbkmoney.clickhouse.initializer.ChInitializer;
import com.rbkmoney.clickhouse.initializer.ConnectionManager;
import dev.vality.testcontainers.annotations.clickhouse.ClickhouseTestcontainer;
import dev.vality.testcontainers.annotations.clickhouse.ClickhouseTestcontainerFactory;
import dev.vality.testcontainers.annotations.clickhouse.ClickhouseTestcontainerSingleton;
import dev.vality.testcontainers.annotations.exception.ClickhouseStartingException;
import dev.vality.testcontainers.annotations.util.GenericContainerUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.testcontainers.containers.ClickHouseContainer;

public class ClickhouseTestcontainerExtension
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger log = LoggerFactory.getLogger(ClickhouseTestcontainerExtension.class);
    private static final ThreadLocal<ClickHouseContainer> THREAD_CONTAINER = new ThreadLocal();

    public void beforeAll(ExtensionContext context) {
        if (ClickhouseTestcontainerExtension.findPrototypeAnnotation(context).isPresent()) {
            ClickHouseContainer container = ClickhouseTestcontainerFactory.container();
            GenericContainerUtil.startContainer(container);
            this.appliedMigrations(container, ClickhouseTestcontainerExtension.findPrototypeAnnotation(context).get().migrations());
            THREAD_CONTAINER.set(container);
        } else if (ClickhouseTestcontainerExtension.findSingletonAnnotation(context).isPresent()) {
            ClickhouseTestcontainerSingleton annotation = ClickhouseTestcontainerExtension.findSingletonAnnotation(context).get();
            ClickHouseContainer container = ClickhouseTestcontainerFactory.singletonContainer();
            if (!container.isRunning()) {
                GenericContainerUtil.startContainer(container);
            } else {
                this.dropDatabase(annotation, container);
            }
            this.appliedMigrations(container, annotation.migrations());
            THREAD_CONTAINER.set(container);
        }
    }

    public void afterAll(ExtensionContext context) {
        if (ClickhouseTestcontainerExtension.findPrototypeAnnotation(context).isPresent()) {
            ClickHouseContainer container = THREAD_CONTAINER.get();
            if (container != null && container.isRunning()) {
                container.stop();
            }
            THREAD_CONTAINER.remove();
        } else if (ClickhouseTestcontainerExtension.findSingletonAnnotation(context).isPresent()) {
            THREAD_CONTAINER.remove();
        }
    }

    private static Optional<ClickhouseTestcontainer> findPrototypeAnnotation(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), ClickhouseTestcontainer.class);
    }

    private static Optional<ClickhouseTestcontainer> findPrototypeAnnotation(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, ClickhouseTestcontainer.class);
    }

    private static Optional<ClickhouseTestcontainerSingleton> findSingletonAnnotation(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), ClickhouseTestcontainerSingleton.class);
    }

    private static Optional<ClickhouseTestcontainerSingleton> findSingletonAnnotation(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, ClickhouseTestcontainerSingleton.class);
    }

    private void appliedMigrations(ClickHouseContainer container, String[] migrations) {
        try {
            ChInitializer.initAllScripts((ClickHouseContainer)container, Arrays.asList(migrations));
            log.info("Successfully applied " + migrations.length + " migrations");
        }
        catch (SQLException ex) {
            throw new ClickhouseStartingException("Error then applied " + migrations.length + " migrations, ", ex);
        }
    }

    private void dropDatabase(ClickhouseTestcontainerSingleton annotation, ClickHouseContainer container) {
        try (Connection connection = ConnectionManager.getSystemConn((ClickHouseContainer)container);){
            try (Statement statement = connection.createStatement();){
                statement.execute(String.format("DROP DATABASE IF EXISTS %s", annotation.dbNameShouldBeDropped()));
            }
            log.info(String.format("Successfully DROP DATABASE IF EXISTS %s", annotation.dbNameShouldBeDropped()));
        }
        catch (SQLException ex) {
            throw new ClickhouseStartingException("Error then drop database dbName=" + annotation.dbNameShouldBeDropped() + ", ", ex);
        }
    }

    public static class ClickhouseTestcontainerContextCustomizerFactory
    implements ContextCustomizerFactory {
        public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
            return (context, mergedConfig) -> {
                if (ClickhouseTestcontainerExtension.findPrototypeAnnotation(testClass).isPresent()) {
                    this.init(context, ClickhouseTestcontainerExtension.findPrototypeAnnotation(testClass).get().properties());
                } else if (ClickhouseTestcontainerExtension.findSingletonAnnotation(testClass).isPresent()) {
                    this.init(context, ClickhouseTestcontainerExtension.findSingletonAnnotation(testClass).get().properties());
                }
            };
        }

        private void init(ConfigurableApplicationContext context, String[] properties) {
            ClickHouseContainer container = THREAD_CONTAINER.get();
            TestPropertyValues.of((String[])new String[]{"clickhouse.db.url=" + container.getJdbcUrl(), "clickhouse.db.user=" + container.getUsername(), "clickhouse.db.password=" + container.getPassword()}).and(properties).applyTo(context);
        }
    }
}

