/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.testcontainers.annotations.ceph;

import dev.vality.testcontainers.annotations.ceph.CephTestcontainer;
import dev.vality.testcontainers.annotations.ceph.CephTestcontainerFactory;
import dev.vality.testcontainers.annotations.ceph.CephTestcontainerSingleton;
import dev.vality.testcontainers.annotations.util.GenericContainerUtil;
import dev.vality.testcontainers.annotations.util.SpringApplicationPropertiesLoader;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.testcontainers.containers.GenericContainer;

public class CephTestcontainerExtension
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger log = LoggerFactory.getLogger(CephTestcontainerExtension.class);
    private static final ThreadLocal<GenericContainer<?>> THREAD_CONTAINER = new ThreadLocal();

    public void beforeAll(ExtensionContext context) {
        if (CephTestcontainerExtension.findPrototypeAnnotation(context).isPresent()) {
            GenericContainer<?> container = CephTestcontainerFactory.container();
            GenericContainerUtil.startContainer(container);
            THREAD_CONTAINER.set(container);
        } else if (CephTestcontainerExtension.findSingletonAnnotation(context).isPresent()) {
            GenericContainer<?> container = CephTestcontainerFactory.singletonContainer();
            if (!container.isRunning()) {
                GenericContainerUtil.startContainer(container);
            }
            THREAD_CONTAINER.set(container);
        }
    }

    public void afterAll(ExtensionContext context) {
        if (CephTestcontainerExtension.findPrototypeAnnotation(context).isPresent()) {
            GenericContainer<?> container = THREAD_CONTAINER.get();
            if (container != null && container.isRunning()) {
                container.stop();
            }
            THREAD_CONTAINER.remove();
        } else if (CephTestcontainerExtension.findSingletonAnnotation(context).isPresent()) {
            THREAD_CONTAINER.remove();
        }
    }

    private static Optional<CephTestcontainer> findPrototypeAnnotation(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), CephTestcontainer.class);
    }

    private static Optional<CephTestcontainer> findPrototypeAnnotation(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, CephTestcontainer.class);
    }

    private static Optional<CephTestcontainerSingleton> findSingletonAnnotation(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getElement(), CephTestcontainerSingleton.class);
    }

    private static Optional<CephTestcontainerSingleton> findSingletonAnnotation(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, CephTestcontainerSingleton.class);
    }

    public static class CephTestcontainerContextCustomizerFactory
    implements ContextCustomizerFactory {
        public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
            return (context, mergedConfig) -> {
                if (CephTestcontainerExtension.findPrototypeAnnotation(testClass).isPresent()) {
                    CephTestcontainer annotation2 = CephTestcontainerExtension.findPrototypeAnnotation(testClass).get();
                    this.init(context, annotation2.bucketName(), annotation2.properties());
                } else {
                    CephTestcontainerExtension.findSingletonAnnotation(testClass).ifPresent(annotation -> this.init(context, annotation.bucketName(), annotation.properties()));
                }
            };
        }

        private void init(ConfigurableApplicationContext context, String bucketName, String[] properties) {
            GenericContainer<?> container = THREAD_CONTAINER.get();
            TestPropertyValues.of((String[])new String[]{"storage.endpoint=" + container.getContainerIpAddress() + ":" + container.getMappedPort(8080), "storage.accessKey=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.ceph.accessKey"), "storage.secretKey=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.ceph.secretKey"), "storage.bucketName=" + bucketName, "s3.endpoint=" + container.getContainerIpAddress() + ":" + container.getMappedPort(8080), "s3.bucket-name=" + bucketName, "s3.access-key=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.ceph.accessKey"), "s3.secret-key=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.ceph.secretKey"), "s3-sdk-v2.enabled=false", "s3-sdk-v2.endpoint=" + String.format("http://%s:%d/", container.getHost(), container.getMappedPort(8080)), "s3-sdk-v2.bucket-name=" + bucketName, "s3-sdk-v2.access-key=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.ceph.accessKey"), "s3-sdk-v2.secret-key=" + SpringApplicationPropertiesLoader.loadDefaultLibraryProperty("testcontainers.ceph.secretKey")}).and(properties).applyTo(context);
        }
    }
}

